AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:height-helper"], function () {
    "use strict";
    var HeightHelper = require("jira/editor/height-helper");
    var Heights = require("jira/editor/height-helper-heights");
    var $ = require('jquery');

    module("HeightHelper", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.el = document.createElement('div');
            this.$el = $(this.el);
            this.$el.css("height", "123px");

            this.anotherEl = document.createElement('div');
            this.$anotherEl = $(this.anotherEl);

            this.heightHelper = new HeightHelper(this.$el);
        },

        teardown: function () {
            this.sandbox.restore();
        },

        stubHeightHelper: function (isComment, isDialog, isBoard) {
            this.sandbox.stub(this.heightHelper, '_isComment').returns(isComment);
            this.sandbox.stub(this.heightHelper, '_isDialog').returns(isDialog);
            this.sandbox.stub(this.heightHelper, '_isBoard').returns(isBoard);
        }
    });

    function assertHeights($el, height) {
        equal($el.css('min-height'), height.min + "px");
        equal($el.css('max-height'), height.max + "px");
    }


    test("Should set correct min-height max-height for dialog", function () {
        this.stubHeightHelper(false, true, false);

        this.heightHelper.setHeights();

        assertHeights(this.$el, Heights.DIALOG_ISSUE_DETAILS);
    });

    test("Should set correct min-height max-height for comment", function () {
        this.stubHeightHelper(true, false, false);

        this.heightHelper.setHeights();

        assertHeights(this.$el, Heights.COMMENT);
    });

    test("Should set correct min-height max-height for board", function () {
        this.stubHeightHelper(false, false, true);

        this.heightHelper.setHeights();

        assertHeights(this.$el, Heights.BOARD_BACKLOG_ISSUE_DETAILS);
    });

    test("Should set correct min-height max-height for comment in dialog", function () {
        this.stubHeightHelper(true, true, false);

        this.heightHelper.setHeights();

        assertHeights(this.$el, Heights.DIALOG_ISSUE_DETAILS);
    });

    test("Should set correct min-height max-height for regular issue view", function () {
        this.stubHeightHelper(false, false, false);

        this.heightHelper.setHeights();

        assertHeights(this.$el, Heights.FULL_ISSUE_DETAILS);
    });

    test("Should remove height attribute when processing element", function () {
        this.stubHeightHelper(false, false, false);

        equal(this.$el.css('height'), '123px');
        this.heightHelper.setHeights();

        assertHeights(this.$el, Heights.FULL_ISSUE_DETAILS);
        equal(this.$el.css('height'), '0px');
    });

    test("Should process passed element", function () {
        this.stubHeightHelper(false, false, false);

        this.heightHelper.setHeights(this.$anotherEl);

        assertHeights(this.$anotherEl, Heights.FULL_ISSUE_DETAILS);
    });

    test("Should process passed element and offset", function () {
        this.stubHeightHelper(false, false, false);
        var offset = 10;

        this.heightHelper.setHeights(this.$anotherEl, offset);

        assertHeights(this.$anotherEl, {
            min: Heights.FULL_ISSUE_DETAILS.min + offset,
            max: Heights.FULL_ISSUE_DETAILS.max + offset
        });
    });
});