define('jira/editor/fsm/states/mode-visual', [
    'jira/editor/fsm/states/state',
    'jira/editor/fsm/states/detached',
    'jira/editor/fsm/events',
    'jira/editor/analytics',
    'jira/editor/constants',
    'underscore'
], function(
    State,
    StateDetached,
    Events,
    Analytics,
    Constants,
    _
) {
    var NAMESPACE = ".stateVisual";

    return function(element) {
        var StateText = require('jira/editor/fsm/states/mode-text');

        [Constants.EVENT_OPERATION, Constants.EVENT_OPERATION_COLOR, Constants.EVENT_OPERATION_ATTACHMENT].forEach(function(eventName) {
            element.$textarea.on(eventName + NAMESPACE, function(event, arg) {
                element.FSM.triggerEvent(eventName, arg);
                return true;
            });
        });

        element.$textarea.on("focus" + NAMESPACE, function () {
            element.FSM.triggerEvent(Events.TEXTAREA_FOCUS);
        });

        element.$textarea.on("keydown" + NAMESPACE, function () {
            element.FSM.triggerEvent(Events.TEXTAREA_FOCUS);
        });

        element.$textarea.on(Constants.EVENT_CHANGE + NAMESPACE, function (event, value) {
            element.FSM.triggerEvent(Constants.EVENT_CHANGE, value);
        });

        var ts = window.performance.now();
        return State("Visual", function Visual(eventType, eventObject) {
            if (eventType === Events.DETACHED && eventObject === element) {
                return StateDetached(element);
            }

            if (eventType === Events.TABS_CHANGE && eventObject === Constants.Modes.TEXT) {
                return StateText(element);
            }

            if (eventType === Constants.EVENT_OPERATION) {
                element.getInstance().focus().executeOperation(eventObject);
            }

            if (eventType === Constants.EVENT_OPERATION_COLOR) {
                element.getInstance().focus().executeOperation("color", eventObject);
            }

            if (eventType === Constants.EVENT_OPERATION_ATTACHMENT) {
                _.each(_.isArray(eventObject) ? eventObject : [eventObject], function(attachment) {
                    element.getInstance().focus().executeOperation("attachment", { attachment: attachment });
                });
            }

            if (eventType === Events.TEXTAREA_FOCUS) {
                element.getInstance().focus();
            }

            if (eventType === Constants.EVENT_CHANGE) {
                element.changeHandler(eventObject);
            }
        }).extend(function(nextState) {
            if (nextState) {
                Analytics.sendEvent("editor.instance.tab.timing.visual", {time: window.performance.now() - ts});
                element.$textarea.off(".stateVisual");
            }

            return nextState;
        });
    };
});
