define('jira/editor/fsm/states/mode-text', [
    'jira/editor/fsm/states/state',
    'jira/editor/fsm/states/detached',
    'jira/editor/fsm/events',
    'jira/editor/analytics',
    'jira/editor/constants'
], function(
    State,
    StateDetached,
    Events,
    Analytics,
    Constants
) {
    return function(element) {
        var StateVisual = require('jira/editor/fsm/states/mode-visual');

        var ts = window.performance.now();
        return State("Text", function Text(eventType, eventObject) {
            if (eventType === Events.DETACHED && eventObject === element) {
                return StateDetached(element);
            }

            if (eventType === Events.TABS_CHANGE && eventObject === Constants.Modes.VISUAL) {
                return StateVisual(element);
            }
        }).extend(function(nextState) {
            if (nextState) {
                Analytics.sendEvent("editor.instance.tab.timing.text", {time: window.performance.now() - ts})
            }

            return nextState;
        });
    };
});
