define('jira/editor/fsm/states/hidden', [
    'jira/editor/fsm/states/state',
    'jira/editor/fsm/states/wrap',
    'jira/editor/fsm/events',
    'jquery',
    'underscore',
    'jira/editor/fsm/states/state-hidden-intersection-observer'
], function (State,
             StateWrap,
             Events,
             $,
             _,
             StateHiddenIntersectionObserver) {

    var VISIBILITY_CHECK_INTERVAL = 100;
    var EVENT_NAMESPACE = ".rteHiddenState";

    return function (element, textarea) {
        var StateInit = require('jira/editor/fsm/states/init');
        var $textarea = $(textarea);
        var tabButton;
        var intervalId;
        var observer = new StateHiddenIntersectionObserver(textarea, element.FSM);

        if (!observer.observe()) {
            var parentTabs = $textarea.parents('.tabs-pane');
            if (parentTabs.length > 0) {
                var tabId = $(parentTabs[0]).attr('id');
                tabButton = $('a[href="#' + tabId + '"]');
                tabButton.on('click' + EVENT_NAMESPACE, function () {
                    //wait for tab to be shown
                    _.defer(function () {
                        element.FSM.triggerEvent(Events.VISIBLE);
                    });
                });
            }
        }
        intervalId = setInterval(function triggerIfVisible() {
            if ($textarea.is(':visible')) {
                element.FSM.triggerEvent(Events.VISIBLE);
            }
        }, VISIBILITY_CHECK_INTERVAL);

        return State("Hidden", function (eventType, eventObject) {
            if (eventType === Events.DETACHED) {
                return StateInit(eventObject);
            }

            if (eventType === Events.VISIBLE || /* corner case for comment box */ eventType === Events.ATTACHED) {
                if ($textarea.is(':visible')) {
                    return StateWrap(element, textarea);
                }
            }
        }).extend(function cleanUp(nextState) {
            if (nextState) {
                if (intervalId) {
                    clearInterval(intervalId);
                    intervalId = undefined;
                }
                if (tabButton) {
                    tabButton.off('click' + EVENT_NAMESPACE);
                }
                observer.cleanup();
            }

            return nextState
        });
    };
});
