define('jira/editor/fsm/states/detached', [
    'jira/editor/fsm/states/state',
    'jira/editor/fsm/events',
    'jira/editor/controller',
    'jira/util/logger',
    'jquery'
], function(
    State,
    Events,
    controller,
    logger,
    $
) {
    var PROPERTY = "richEditorInstance";
    var PROPERTY_LOADING = "richEditorInstance_loading";

    return function(element) {
        var StateInit = require('jira/editor/fsm/states/init');
        var StateAttached = require('jira/editor/fsm/states/attached');

        setTimeout(function() {
            element.FSM.triggerEvent(Events.DESTROY_TIMEOUT);
        });

        return State("Detached", function (eventType, eventObject) {
            if (eventType === Events.ATTACHED && eventObject === element) {
                return StateAttached(eventObject);
            }

            if (eventType === Events.DESTROY_TIMEOUT) {
                if (element.undoManager) {
                    element.undoManager.destroy();
                    delete element.undoManager;
                }

                element.uncoverTextarea();

                if (element[PROPERTY]) {
                    try {
                        element[PROPERTY].destroy();
                    } catch(e) {
                        logger.debug("Editor destroy exception:", e);
                    }
                    delete element[PROPERTY];
                }

                delete element[PROPERTY_LOADING];

                delete element.$textarea;

                //tinymce adds display: none to the element. revert the change
                if (element.style.display === 'none') {
                    element.style.display = '';
                }

                controller.destroyEditor(element);

                var $element = $(element);
                //tinymce would try to reuse it
                $element.removeAttr("id", "aria-hidden", "data-content-present");
                $element.empty();

                logger.trace("jira.editor.plugin.detached");

                return StateInit(element);
            }
        });
    };
});
