define("jira/editor/undo-history-store", [

], function(

) {
    var fieldData = [];

    var undoHistoryStore = function() {};

    /**
     * Stores the undo history for the given edit context
     * Overwrites previously saved data
     * @param id editor id
     * @param undoData the undo stack
     */
    undoHistoryStore.prototype.put = function(id, undoData) {
        if (!id) {
            return;
        }
        fieldData[keyFor(id)] = undoData;
    };

    /**
     * Retrieves the undo history for the given edit context
     * @param id editor id
     */
    undoHistoryStore.prototype.get = function(id) {
        return fieldData[keyFor(id)];
    };

    var undoHistoryStoreInstance = new undoHistoryStore();
    return {
        get: undoHistoryStoreInstance.get,
        put: undoHistoryStoreInstance.put
    };


    function keyFor(id) {
        return 'jira.richeditor.history.' + id;
    }
});