AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:api"], function() {
    "use strict";

    var SupportedOperations = require("jira/richeditor/editor-supported-operations");


    module("EditorSupportedOperations", {
        setup: function () {},
        teardown: function () {}
    });

    test("Should return supported wiki operations", function () {
        var expected = ['bold', 'italic', 'underline', 'bullet-list', 'numbered-list',
            'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'paragraph', 'paragraph-quote', 'block-quote',
            'monospace', 'delete', 'superscript', 'subscript', 'cite', 'hr', 'color', 'icon',
            'attachment', 'code', 'panel', 'noformat', 'table', 'undo', 'redo'];

        deepEqual(SupportedOperations.getWikiOperations().sort(), expected.sort());
    });

    test("Should return required html tags for supported wiki operations", function () {
        var expected = ['strong', 'b', 'em', 'i', 'ins', 'u', 'li', 'ul', 'ol', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6',
            'blockquote', 'samp', 'tt', 'code', 'del', 'sup', 'sub', 'cite', 'hr', 'font', 'img', 'a', 'pre', 'table', 'thead',
            'tbody', 'tr', 'th', 'td', 'tfoot', 'caption', 'colgroup', 'col', 'br', 'span', 'p', 'div'];

        deepEqual(SupportedOperations.getRequiredHtmlTags().sort(), expected.sort());
    });


    module("EditorSupportedOperations - mapWikiOperationToHtmlTags", {
        setup: function () {},
        teardown: function () {}
    });

    test("Should work in case of empty arrays", function(assert) {
        var operations = [];
        var extraTags = [];
        var expectations = [];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should add extra tags", function(assert) {
        var operations = [];
        var extraTags = ["div", "a"];
        var expectations = ["a", "div"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should map operation to tags", function(assert) {
        var operations = ["italic"];
        var extraTags = [];
        var expectations = ["em", "i"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should map operations to tags", function(assert) {
        var operations = ["italic", "noformat"];
        var extraTags = [];
        var expectations = ["em", "i", "pre"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should do not map empty operations", function(assert) {
        var operations = ["paragraph"];
        var extraTags = [];
        var expectations = [];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should pass 1-1 operation", function(assert) {
        var operations = ["h3"];
        var extraTags = [];
        var expectations = ["h3"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should do not produce duplicates", function(assert) {
        var operations = ["bullet-list", "numbered-list"];
        var extraTags = ["li"];
        var expectations = ["ol", "ul", "li"];

        assertMapping(operations, extraTags, expectations);
    });

    test("Should concat mapped operations and extra tags", function(assert) {
        var operations = ["bullet-list", "numbered-list", "bold", "icon", "h1"];
        var extraTags = ["a", "cite"];
        var expectations = ["ol", "ul", "li", "b", "strong", "img", "a", "cite", "h1"];

        assertMapping(operations, extraTags, expectations);
    });


    function assertMapping(operations, extraTags, expectations) {
        deepEqual(
            SupportedOperations.mapWikiOperationToHtmlTags(operations, extraTags).sort(),
            expectations.sort()
        );
    }
});