AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:instance"], function () {
    "use strict";

    var Backbone = require("backbone");
    var _ = require("underscore");
    var contextPath = require("wrm/context-path");
    var EditorInstance = require("jira/editor/instance");


    module("EditorInstance", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.editor = _.extend({
                getContent: function () {
                    return _.uniqueId();
                },
                getBody: function () {},
                insertContent: this.sandbox.stub(),
                focus: this.sandbox.stub(),
                nodeChanged: this.sandbox.stub()
            }, Backbone.Events);

            this.editorInstance = new EditorInstance(this.editor);
            this.editorInstance.init(this.editor);
        },
        teardown: function () {
            this.sandbox.restore();
        },
        assertFocusNotApplied: function () {
            var returnValue = this.editorInstance.focus();

            sinon.assert.notCalled(this.editor.focus);
            sinon.assert.notCalled(this.editor.nodeChanged);
            strictEqual(returnValue, this.editorInstance, 'focus method should return EditorInstance');
        }
    });

    test("Should handle focus when editor is initialised", function () {
        this.editor.initialized = true;

        var returnValue = this.editorInstance.focus();

        sinon.assert.calledOnce(this.editor.focus);
        sinon.assert.calledOnce(this.editor.nodeChanged);
        strictEqual(returnValue, this.editorInstance, 'focus method should return EditorInstance');
    });

    test("Should not apply focus when editor is uninitialised, or destroyed, or removed", function () {
        this.editor.initialized = false;
        this.assertFocusNotApplied();

        this.editor.initialized = true;
        this.editor.removed = true;
        this.assertFocusNotApplied();

        this.editor.initialized = true;
        this.editor.removed = false;
        this.editor.destroyed = true;
        this.assertFocusNotApplied();
    });

    test("Blur trigger change event on editor instance", function () {
        this.editorInstance.trigger = sinon.spy();

        this.editor.trigger("blur");

        ok(this.editorInstance.trigger.calledOnce);
    });

    test("Placeholder image should be rendered when there is no href on attachment", function () {
        var attachedImageSpy =this.sandbox.spy(JIRA.Editor.Tags.Templates, "attachedImage");

        this.editorInstance.executeOperation('attachment', {
            attachment: {
                type: 'image',
                name: 'attachmentName',
                thumbnailable: true
            }
        });

        ok(JIRA.Editor.Tags.Templates.attachedImage.calledOnce);
        ok(this.editor.insertContent.calledOnce);
        sinon.assert.calledWith(attachedImageSpy, {
            source: contextPath() + '/images/icons/attach/image.gif',
            filename: "attachmentName"
        });
    });
});