AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:api"], function() {
    "use strict";

    var $ = require("jquery");
    var tinymce = require("jira/editor/tinymce");

    module("EditorCreate",  {
        setup: function() {
            this.mockedContext = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create({ });

            this.EditorInstance = function() {
                this.init = function() { };
            };
            this.mockedContext.mock("jira/editor/instance", this.EditorInstance);
            this.element = $("<div>");
            this.element.appendTo("#qunit-fixture");
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    asyncTest("build should init MCE", function() {
        initTinyMCE.call(this);
    });

    asyncTest('Should call customization callbacks', function() {
        var SchemaBuilder = this.mockedContext.require("jira/editor/schema-builder");
        this.mockedContext.mock("jira/editor/schema-builder", SchemaBuilder);

        var Customizer = this.mockedContext.require("jira/editor/customizer");
        this.mockedContext.mock("jira/editor/customizer", Customizer);

        var fn = sinon.spy();
        var fn2 = sinon.spy();
        Customizer.customizeSettings(fn);
        Customizer.customizeSettings(fn2);

        initTinyMCE.call(this).then(function() {
            assertCallbackCall(fn);
            assertCallbackCall(fn2);
        });

        function assertCallbackCall(callback) {
            sinon.assert.calledOnce(callback);
            sinon.assert.calledWithMatch(callback,
                sinon.match.hasOwn("schema"),           // tinymceSettings
                sinon.match.hasOwn("majorVersion"),     // tinymce
                sinon.match.instanceOf(SchemaBuilder));
        }
    });

    asyncTest("tinyMCE should not be initialized when element is not attached to DOM", function() {
        var EditorCreate = this.mockedContext.require("jira/editor/create");

        var initMCE = this.sandbox.spy(tinymce, "init");

        var mockedElement = $("<div>");
        var builder = EditorCreate.builder(mockedElement.get(0));

        builder.build().fail(function() {
            start();

            ok(initMCE.notCalled, "tinymce.init not called at all");
        });
    });

    test("build should require plugins and css resources", function(assert) {
        var wrmRequire = this.sandbox.stub().returns(new $.Deferred());
        this.mockedContext.mock("wrm/require", wrmRequire);

        var EditorCreate = this.mockedContext.require("jira/editor/create");

        var urls = {};
        this.sandbox.stub(tinymce.PluginManager, "urls", urls);

        EditorCreate.builder()
            .withPlugin("test-plugin", "test-plugin-resource")
            .build();

        assert.equal(wrmRequire.callCount, 1, "WRM.require called once");
        ok(wrmRequire.calledWith(["wr!test-plugin-resource"]), "WRM.require called with [wr!test-plugin]");
        assert.equal(urls["test-plugin"], "test-plugin-resource", "PluginManager.urls was altered.");
    });

    test("content_css should be set with css resources", function(assert) {
        var wrmRequire = this.sandbox.stub().returns(new $.Deferred());
        this.mockedContext.mock("wrm/require", wrmRequire);

        var EditorResources = {
            loadPlugins: function() {
                return new $.Deferred().resolve();
            }
        };
        this.mockedContext.mock("jira/editor/resources", EditorResources);

        var EditorCreate = this.mockedContext.require("jira/editor/create");

        EditorResources.loadCssResources = function() {
            return new $.Deferred().resolve(["test-resource.css"]).promise();
        };

        var builder = EditorCreate.builder(this.element.get(0));

        var editor = { on: function() {}};
        this.sandbox.stub(tinymce, "init", function(settings) {
            assert.deepEqual(settings.content_css, ["test-resource.css"]);
        });

        builder.build();

    });


    /**
     * Call it with the module context.
     */
    function initTinyMCE() {
        var EditorCreate = this.mockedContext.require("jira/editor/create");

        var editor = {
            on: function(eventName, fn) {
                if(eventName === "init") {
                    fn();
                }
            },
            getContainer: function() {
                return {
                    classList: {
                        add: function() {

                        }
                    }
                }
            },
            schema: { children: {} }
        };

        var initMCE = this.sandbox.stub(tinymce, "init", function(settings) {
            settings.setup(editor);
        });

        var builder = EditorCreate.builder(this.element.get(0));
        return builder.build().then(function() {
            start();

            ok(initMCE.calledOnce, "tinymce.init called once");
        });
    }
});