AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:controller'], function () {

    var $ = require("jquery");
    var controller = require('jira/editor/controller');

    module("EditorConverterInstance", {
        setup: function () {
            this.formWithFormToken = $('<form><textarea/><input name="formToken" value="someFormToken"/></form>').appendTo('#qunit-fixture')[0];
            this.formWithoutFormToken = $('<form><textarea/></form>').appendTo('#qunit-fixture')[0];
        }
    });

    test('renderParams should return formToken', function () {
        var params = controller.getRenderParams($(this.formWithFormToken).find('textarea'));
        equal(params.formToken, "someFormToken");
    });

    test('renderParams should return "undefined" string when no formToken is present', function () {
        var params = controller.getRenderParams($(this.formWithoutFormToken).find('textarea'));
        equal(params.formToken, "undefined");
    });

});