/**
 * We are not encoding uri in the same way as encodeUriComponent do.
 * Characters - _ . ! ~ * ' ( ) were not encoded by encodeUriComponents, but we are encoding ! ~ ' ( ).
 * Space is also encoded as + sign, not %20
 * | also doesn't work in markup
 *
 * Similar happen to confluence pages
 * @module jira/editor/converter/util/uri
 */
define('jira/editor/converter/util/uri', [
    'exports',
    'atlassian/libs/uri-1.14.1'
], function (
    exports,
    urijs
) {

    exports.decodeUri = function (text) {
        return urijs.decodeQuery(text || "", true);
    };

    exports.encodeUri = function (text) {
        return urijs.encodeQuery(text || "", true);
    }
});


