AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:converter"],function(){require(["jira/editor/converter/util/strings"],function(a){module("Strings");test("Test for nulls in string",function(){equal(a.startsWith(null,"str"),false);equal(a.endsWith(null,"str"),false);equal(a.substringAfter(null,"str"),null);equal(a.contains(null,"str"),false)});test("Test for nulls in a search string",function(){equal(a.startsWith("str",null),false);equal(a.endsWith("str",null),false);equal(a.substringAfter("str",null),"");equal(a.contains("str",null),false)});test("Empty string should have an empty hash",function(){equal(a.hashCode(),"","Empty string returns empty hash");equal(a.hashCode(null),"","Empty string returns empty hash");equal(a.hashCode(""),"","Empty string returns empty hash")});test("Returns hash of a string",function(){equal(a.hashCode("test"),"3556498","String gets hashed")});test("Replace string",function(){equal(a.replace("test","e","o"),"tost","Single character should be replaced");equal(a.replace("test","test","beer"),"beer","Full string match should be replaced");equal(a.replace("my best test for a string replace test","test","quest"),"my best quest for a string replace quest","All of the multiple string matches should be replaced");equal(a.replace("abba abba abba abba","abba","abba abba"),"abba abba abba abba abba abba abba abba","String should be replaced even if replace string is the same");equal(a.replace("|abba| |abba| |abba| |abba|","abba",""),"|| || || ||","Replace string empty should remove occurrence from the original string");equal(a.replace("|abba| |abba| |abba| |abba|","not matched",""),"|abba| |abba| |abba| |abba|","No match should not be replaced")});test("Extract filename from href",function(){equal(a.getFilenameFromHref("http://localhost:8090/jira/secure/attachment/10000/10000_IssueTypes.png"),"IssueTypes.png");equal(a.getFilenameFromHref("http://localhost:8090/jira/secure/attachment/10000/10000_Issue_Types.png"),"Issue_Types.png");equal(a.getFilenameFromHref("/jira/secure/attachment/10000/10000_IssueTypes.png"),"IssueTypes.png");equal(a.getFilenameFromHref("/jira/secure/attachment/10000/10000_Issue_Types.png"),"Issue_Types.png");equal(a.getFilenameFromHref("jira/secure/attachment/10000/10000_IssueTypes.png"),"IssueTypes.png");equal(a.getFilenameFromHref("jira/secure/attachment/10000/10000_Issue_Types.png"),"Issue_Types.png");equal(a.getFilenameFromHref("jira/secure/attachment/10000/Issue_Types.png"),"Issue_Types.png")});test("Temporary attachment path",function(){ok(a.isTemporaryAttachmentPath("http://localhost:8090/jira/secure/temporaryattachment/10000/10000_IssueTypes.png"));ok(a.isTemporaryAttachmentPath("http://localhost:8090/jira/secure/temporaryattachment/10000/10000_Issue_Types.png"));ok(a.isTemporaryAttachmentPath("/jira/secure/temporaryattachment/10000/10000_IssueTypes.png"));ok(a.isTemporaryAttachmentPath("/jira/secure/temporaryattachment/10000/10000_Issue_Types.png"));ok(a.isTemporaryAttachmentPath("jira/secure/temporaryattachment/10000/10000_IssueTypes.png"));ok(a.isTemporaryAttachmentPath("jira/secure/temporaryattachment/10000/10000_Issue_Types.png"));ok(a.isTemporaryAttachmentPath("jira/secure/temporaryattachment/10000/Issue_Types.png"));ok(a.isTemporaryAttachmentPath("/secure/temporaryattachment/10000/Issue_Types.png"));ok(a.isTemporaryAttachmentPath("http://localhost:8090/secure/temporaryattachment/10000/10000_Issue_Types.png"));notOk(a.isTemporaryAttachmentPath(undefined));notOk(a.isTemporaryAttachmentPath(""));notOk(a.isTemporaryAttachmentPath("http://localhost:8090/jira/secure/attachment/10000/10000_IssueTypes.png"));notOk(a.isTemporaryAttachmentPath("jira/secure/attachment/10000/Issue_Types.png"))})})});