AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:converter'], function () {
    var NodeHandler = require('jira/editor/converter/handlers/node-handler');
    var $ = require('jquery');

    module('NodeHandler', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Test no wrapping selector: table.node', function () {

        var tableNode = $('<table><tbody><tr><td><b>bold</b></td></tr></table></tbody>').get(0);
        var node = $(tableNode).find('b').get(0);

        ok(NodeHandler.isInsideTable(node));
    });

    test('Test in wrapping selector: table.wrapper.node', function () {

        var tableNode = $('<table><tbody><tr><td><p><b>bold</b></p></td></tr></table></tbody>').get(0);
        var node = $(tableNode).find('b').get(0);

        ok(NodeHandler.isInsideTable(node));
    });

    test('Test no outer table', function () {

        var outerNode = $('<p><b>bold</b></p>').get(0);
        var node = $(outerNode).find('b').get(0);
        console.log(node);

        ok(!NodeHandler.isInsideTable(node), "Table found where it does not exist");
    });
});