AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:converter'], function () {
    "use strict";
    var RTELinkHandler = require('jira/editor/converter/handlers/link-handler');
    var wrmContextPath = require('wrm/context-path');

    module('RTELinkHandler',{
        setup: function () {
            this.context = wrmContextPath();
            this.hostURL = document.location.origin + this.context;
        }
    });

    test('Test isAttachment', function() {
        ok(RTELinkHandler.isAttachment(this.hostURL + '/secure/attachment/10002/test.txt'), 'Should recognise Attachment Link from full url');
        ok(RTELinkHandler.isAttachment(this.context + '/secure/attachment/10003/packed.zip'), 'Should properly recognise Attachment Link without domain');
        ok(RTELinkHandler.isAttachment('../secure/attachment/10004/suspicious.exe'), 'Should properly recognise Attachment Link from relative url');
        ok(RTELinkHandler.isAttachment(this.hostURL + '/secure/attachment/10000/10000_IssueTypes.png'), 'Should recognise image Attachments Links');
        ok(!RTELinkHandler.isAttachment(this.hostURL + '/browse/PROJ-1'), 'Should not recognise issue links');
        ok(!RTELinkHandler.isAttachment('https://www.youtube.com/watch?v=eWM2joNb9NE'), 'Should not recognise arbitrary links');
    });

    test('Test isIssue', function() {
        ok(RTELinkHandler.isIssue(this.hostURL + '/browse/PROJ-1'), 'Should properly recognise Issue Link from full url');
        ok(RTELinkHandler.isIssue(this.context + '/browse/PROJ-1'), 'Should properly recognise Issue Link without domain');
        ok(!RTELinkHandler.isIssue(this.hostURL + '/secure/thumbnail/10000/_thumb_10000.png'), 'Should not recognise image attachments');
        ok(!RTELinkHandler.isIssue('https://www.youtube.com/watch?v=eWM2joNb9NE'), 'Should not recognise arbitrary links');
    });

    test('Test isMailto', function() {
        ok(RTELinkHandler.isMailto('mailto:root@example.com'), 'Should properly recognise mail link');
        ok(!RTELinkHandler.isMailto('fb:root@example.com'), 'Should not recognise non-mail url');
        ok(!RTELinkHandler.isMailto(this.hostURL + '/secure/thumbnail/10000/_thumb_10000.png'), 'Should not recognise regular urls');
    });
});
