define("jira/editor/converter/handlers/hr-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/handlers/empty-handler"
], function (
    NodeHandler,
    TextHandler,
    EmptyHandler
) {
    "use strict";

    /**
     * @class HorizontalLineHandler
     * @extends NodeHandler
     */
    return NodeHandler.extend({
        init: function HorizontalLineHandler(node) {
            this.node = node;
        },

        before: function () {
            return new EmptyHandler();
        },

        children: function () {
            var textHandler = new TextHandler({
                textContent: "----",
                preformatted: true
            });
            return [textHandler];
        },

        after: function () {
            return new EmptyHandler();
        }
    });
});