define("jira/editor/converter/handlers/code-block-handler", [
    "jira/editor/converter/handlers/block-handler",
    "jira/editor/converter/handlers/text-handler",
    "jquery"
], function (
    BlockHandler,
    TextHandler,
    $
) {
    "use strict";

    var CodeBlockHandler = BlockHandler.extend({
        init: function CodeBlockHandler(node) {
            this._super(node);

            this.language = this.getLanguage();
        },

        getLanguage: function () {
            var pre = $(this.node).is('pre') ? this.node : this.node.querySelector('pre');
            var language = $(pre).attr("data-language") || (pre && pre.className);
            return (language in languageMap) ? languageMap[language] : '';
        },

        before: function () {
            var attrs = [];
            if (this.language) {
                attrs.push(this.language);
            }
            if (this.attrs) {
                attrs.push(this.attrs);
            }

            var attrs = (attrs.length) ? ':' + attrs.join('|') : '';
            return TextHandler.createPreformattedTextHandler('{code' + attrs + '}');
        },

        after: function () {
            return TextHandler.createPreformattedTextHandler('{code}');
        }
    });

    var languageMap = {
        'code-actionscript': 'actionscript',
        'code-java': 'java',
        'code-javascript': 'javascript',
        'code-sql': 'sql',
        'code-xml': 'xml',
        'code-none': 'none'
    };

    return CodeBlockHandler;
});