define('jira/editor/context-detector', [
    'jira/editor/converter/util/rte-strings',
    'underscore',
    'jquery'
], function (
    RteStrings,
    _,
    $
) {
    //".noformat.panel" is not needed here since it exists only with "pre"
    var PRE_SELECTOR = "pre,.code.panel,.preformatted.panel,.panelHeader,panel-title";
    var TABLE_SELECTOR = "table";
    var A_SELECTOR = "a";

    var ContextDetector = {};

    ContextDetector.detectPre = function (node) {
        return detectGenericContext(node, PRE_SELECTOR);
    };

    ContextDetector.detectTable = function (node) {
        return detectGenericContext(node, TABLE_SELECTOR);
    };

    ContextDetector.detectA = function (node) {
        return detectGenericContext(node, A_SELECTOR);
    };

    ContextDetector.detectPreWithinSelection = function (selection) {
        return detectGenericContextWithinSelection(selection, PRE_SELECTOR);
    };

    return ContextDetector;


    function detectGenericContext(node, selector) {
        return $(node || {}).closest(selector).length > 0;
    }

    function detectGenericContextWithinSelection(selection, selector) {
        try {
            // selection content may contain elements such as %MCECOPIED%, so it sometimes can't be parsed
            return $((_.isString(selection) ? RteStrings.parseHtml(selection) : selection) || {}).find(selector).length > 0;
        } catch (e) {
            return false;
        }
    }
});