AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:context-detector"],function(){var d=require("jquery");function b(){this.sandbox=sinon.sandbox.create();this.ContextDetector=require("jira/editor/context-detector")}module('ContextDetector "pre"',{setup:function(){b.call(this);this.containers=[d("<pre></pre>"),d('<pre class="noformat panel"></pre>'),d('<pre class="code panel"></pre>'),d('<div class="code panel"></div>'),d('<div class="preformatted panel"></div>'),d('<pre class="preformatted panel"></pre>'),d('<pre class="panelHeader"></pre>'),d("<div></div><pre></pre>")];this.content=d('<div class="fancy-style">text</div>');this.panelTitle=d("<panel-title>title</panel-title>")},teardown:function(){this.sandbox.restore()}});test('Should detect "pre" context when container is selected',function(){this.containers.forEach(function(e){ok(this.ContextDetector.detectPre(e),'"pre" context should be detected for node '+c(e))},this)});test('Should detect "pre" context when paneltitle is selected',function(){this.containers.forEach(function(e){e.append(this.panelTitle);e.append(this.content);ok(this.ContextDetector.detectPre(this.panelTitle),'"pre" context should be detected for node '+c(this.panelTitle))},this)});test('Should detect "pre" context when content is selected',function(){this.containers.forEach(function(e){e.append(this.content);ok(this.ContextDetector.detectPre(this.content),'"pre" context should be detected for node '+c(this.content))},this)});test('Should not detect "pre" context #1',function(){var e=d('<div class="code panel">pre context</div><table><tbody><tr><td>table context</td></tr></tbody></table>');var f=e.find("td");ok(!this.ContextDetector.detectPre(f),'"pre" context should not be detected for tree '+a(e))});test('Should not detect "pre" context #2',function(){var e=d('<div class="panel"><span>no "pre" context</span></div>');var f=e.find("span");ok(!this.ContextDetector.detectPre(f),'"pre" context should not be detected for tree '+a(e))});module('ContextDetector "table"',{setup:function(){b.call(this);this.containers=[d("<table></table>"),d("<div></div><table></table>"),d("<table><tbody><tr><td></td></tr></tbody></table>"),d("<table><thead><tr><th>title</th></tr></thead><tbody><tr><td>table context</td></tr></tbody></table>")]},teardown:function(){this.sandbox.restore()}});test('Should detect "table" context when container is selected',function(){this.containers.forEach(function(e){ok(this.ContextDetector.detectTable(e),'"table" context should be detected for node '+c(e))},this)});test('Should detect "table" context when cell is selected',function(){this.containers.forEach(function(e){var f=e.find("td");if(f.length){ok(this.ContextDetector.detectTable(f),'"table" context should be detected for node '+c(f))}var f=e.find("th");if(f.length){ok(this.ContextDetector.detectTable(f),'"table" context should be detected for node '+c(f))}},this)});test('Should detect "table" context from complex cell content',function(){var e=d("<table><tbody><tr><td><div><strong><em>content</em></strong><pre><span>pre</span></pre></div></td></tr></tbody></table>");var f=e.find("em");if(f.length){ok(this.ContextDetector.detectTable(f),'"table" context should be detected for node '+c(f))}var f=e.find("pre");if(f.length){ok(this.ContextDetector.detectTable(f),'"table" context should be detected for node '+c(f))}});test('Should not detect "table" context #1',function(){var e=d('<div><div class="code panel">pre context</div></div><table><tbody><tr><td>table context</td></tr></tbody></table>');var f=e.find("div.code.panel");ok(!this.ContextDetector.detectTable(f),'"table" context should not be detected for tree '+a(e))});test('Should not detect "table" context #2',function(){var e=d('<div style="display:table"><div style="display:table-row"><div style="display:table-cell"><span class="css-table">css table</span></div></div></div>');var f=e.find("span.css-table");ok(!this.ContextDetector.detectTable(f),'"table" context should not be detected for tree '+a(e))});module('ContextDetector "a"',{setup:function(){b.call(this);this.containers=[d("<a></a>"),d('<a name="anchor">link</a>'),d('<a href="#">link</a>'),d("<div></div><a></a>")];this.content=d("<strong><em>link</em></strong>")},teardown:function(){this.sandbox.restore()}});test('Should detect "a" context when container is selected',function(){this.containers.forEach(function(e){ok(this.ContextDetector.detectA(e),'"a" context should be detected for node '+c(e))},this)});test('Should detect "a" context when content is selected',function(){this.containers.forEach(function(e){e.append(this.content);ok(this.ContextDetector.detectA(this.content),'"a" context should be detected for node '+c(this.content))},this)});test('Should not detect "a" context',function(){var e=d('<div><div class="a">pre context</div></div><a></a>');var f=e.find("div.a");ok(!this.ContextDetector.detectTable(f),'"a" context should not be detected for tree '+a(e))});test('Should not detect "a" context for node whose child has that context',function(){var e=d('<div><div class="a"><a>link</a></div></div>');var f=e.find("div.a");ok(!this.ContextDetector.detectTable(f),'"a" context should not be detected for tree '+a(e))});module("ContextDetector all contexts combined",{setup:function(){b.call(this);this.trees=[d("<pre><table><tr><td><a><div></div></a></td></tr></table></pre>"),d("<pre><a><table><tr><td><div></div></td></tr></table></a></pre>"),d("<table><tr><td><pre><a><div></div></a></pre></td></tr></table>"),d("<table><tr><td><a><pre><div></div></pre></a></td></tr></table>"),d("<a><pre><table><tr><td><div></div></td></tr></table></pre></a>"),d("<a><table><tr><td><pre><div></div></pre></td></tr></table></a>"),]},teardown:function(){this.sandbox.restore()}});test('Should detect "pre" context when container is selected',function(){this.trees.forEach(function(e){var f=e.find("div");ok(this.ContextDetector.detectPre(f),'"pre" context should be detected for tree '+a(e));ok(this.ContextDetector.detectTable(f),'"table" context should be detected for tree '+a(e));ok(this.ContextDetector.detectA(f),'"a" context should be detected for tree '+a(e))},this)});module('ContextDetector "pre" selection',{setup:function(){b.call(this);this.goodTrees=[d("<div><pre></pre></div>"),d('<div><div><pre class="noformat panel"></pre></div><div><strong><a>link</a></strong></div>'),d('<div><pre class="code panel"></pre></div>'),d('<div><div class="code panel"></div></div>'),d('<div><div class="preformatted panel"></div></div>'),d('<div><pre class="preformatted panel"></pre></div>'),d('<div><div class="panelHeader"></div></div>'),d("<div></div><div><pre></pre></div>")];this.badTrees=[d("<pre></pre>"),d('<pre class="noformat panel"></pre>'),d('<pre class="code panel"></pre>'),d('<div class="code panel"></div>'),d('<div class="preformatted panel"></div>'),d('<pre class="preformatted panel"></pre>'),d("<div></div><pre></pre>")];this.maliciousNode="%MCECOPIED%"},teardown:function(){this.sandbox.restore()}});test('Should detect "pre" within selection',function(){this.goodTrees.forEach(function(e){ok(this.ContextDetector.detectPreWithinSelection(e),'"pre" within selection should be detected for tree '+a(e))},this)});test('Should not detect "pre" within selection',function(){this.badTrees.forEach(function(e){ok(!this.ContextDetector.detectPreWithinSelection(e),'"pre" within selection should not be detected for tree '+a(e))},this);ok(!this.ContextDetector.detectPreWithinSelection(this.maliciousNode),'"pre" within selection should not be detected when node cannot be parsed')});test("Should not fail on inline text",function(){ok(!this.ContextDetector.detectPreWithinSelection('workflow documentation for end users ("&lt;a target="_blank" href="https://confluence.atlassian.com/display/JIRA/Configuring+Workflow'))});function c(e){return d(e).get(0).cloneNode(false).outerHTML}function a(e){return d(e).get(0).outerHTML}});