AJS.$(function() {
    AJS.JFEP = AJS.JFEP || {};

    var tabReadyCallback = function($container) {
        AJS.$('.review-filter', $container).live('change', function (e) {
            var val = AJS.$(e.target).val(),
                    visibility = AJS.$(e.target).is(':checked') ? 'block' : 'none';
            AJS.$('.review-status-' + val).css('display', visibility);
        });
        AJS.$('.tab-content', $container).find('.project-activity:gt(0)').addClass('hidden');
        AJS.$('#activity-filter', $container).live('change', function (e) {
            var val = AJS.$('#activity-filter').val();
            AJS.$('.project-activity').addClass('hidden');
            AJS.$('.limit-' + val).removeClass('hidden');
        });
    };

    AJS.$("#preview-hide-tab", AJS.$(document)).live('click', function(e) {
        AJS.$("#preview_form").submit();
        e.preventDefault();
    });

    // register JS to be called on tab ready if possible
    if (JIRA.ViewIssueTabs) {
        JIRA.ViewIssueTabs.onTabReady(tabReadyCallback);
    } else {
        tabReadyCallback(document);
    }

    AJS.JFEP.reviewIssueToggle = function () {
        AJS.$('.review-issue-target').addClass('hidden');
        AJS.$('.review-issue-trigger').click(function(e) {
            e.preventDefault(); // Leave the mouse focus on the trigger
            var target = AJS.$(this).attr('href');
            AJS.$(target).toggleClass('hidden');
        });
    };

    AJS.JFEP.ignoreCookieName = function() {
        var username = AJS.$("#header-details-user-fullname").attr("data-username");
        if (!username) {
            username = "__ANON";
        }
        return "JFEP.ignoredAppLinks." + username;
    };

    AJS.JFEP.ignoreAppLink = function(applicationId) {
        // append cookie - have to hand-roll our cookie handling code until AJS-574 is fixed
        var cookieValue;
        var cookie = document.cookie;
        if (cookie.indexOf(AJS.JFEP.ignoreCookieName() + "=") > -1) {
            var rx = new RegExp(AJS.JFEP.ignoreCookieName() + "=([^;]*)");
            cookieValue = rx.exec(cookie)[1];
        } else {
            cookieValue = "";
        }

        if (cookieValue.indexOf(applicationId) == -1) {
            // set cookie so error messages suppressed
            cookieValue += (cookieValue.length > 0 ? "|" : "") + applicationId;
            var expires=new Date();
            expires.setDate(expires.getDate()+365);
            document.cookie = AJS.JFEP.ignoreCookieName() + "=" + cookieValue + "; " +
                    "expires=" + expires.toUTCString() + "; " +
                    "path=" + contextPath;
        }
    };

    AJS.JFEP.clearIgnoredAppLinks = function() {
        // clear cookie - have to hand-roll our cookie handling code until AJS-574 is fixed
        var expires=new Date();
        expires.setDate(expires.getDate()-5);
        document.cookie = AJS.JFEP.ignoreCookieName() + "=expired;" +
                    "expires=" + expires.toUTCString() + "; " +
                    "path=" + contextPath;
    };

    AJS.$(".ignore-applink").live("click", function () {
        var applinkId = AJS.$(this).attr("data-id");
        AJS.JFEP.ignoreAppLink(applinkId);
        AJS.$(this).parents(".credentials-required-message").slideUp();
    });

    AJS.$(".clear-ignored-applinks").live("click", function () {
        AJS.JFEP.clearIgnoredAppLinks();
        document.location.reload(true);
    });

    AJS.JFEP.loadMoreChangesets = function (contextPath, issueKey, searchIndexParam, completeCallback) {
        jQuery("#more-changesets-action-spinner").show();
        jQuery("#more-changesets-blurb").hide();
        JIRA.SmartAjax.makeRequest({
            url: contextPath + "/rest/tabs/1.0/more-changesets/" + issueKey + searchIndexParam,
            type: "GET",
            dataType: "json",
            contentType: "application/json",
            complete: function (xhr, status, smartAjaxResult) {
                if (!smartAjaxResult.successful) {
                    // The REST service provides nice and informative error messages, so let's use them,
                    // *except* for some cases where JIRA.SmartAjax.buildSimpleErrorContent() provides better
                    // error messages. Lovely.
                    // TODO: JIRA.SmartAjax.buildSimpleErrorContent() should really handle this logic for us.
                    var errorContent = (smartAjaxResult.status !== 401 || smartAjaxResult.statusText === JIRA.SmartAjax.SmartAjaxResult.TIMEOUT)
                        ? JSON.parse(smartAjaxResult.data).errorMessages
                        : JIRA.SmartAjax.buildSimpleErrorContent(smartAjaxResult);
                    jQuery(document).trigger(JIRA.SERVER_ERROR_EVENT, errorContent);
                } else {
                    completeCallback(smartAjaxResult.data.changesets);
                }
            }
        });
    };
});