AJS.fisheyeGadgets = {
    addParameterSet: function(name, values)
    {
        var result = "";
        if (values && jQuery.trim(values).length > 0)
        {
            var valueArray = jQuery.trim(values).split(/[ ,]+/);
            for (var i in valueArray)
            {
                result += "," + name + "=" + valueArray[i];
            }
        }
        return result;
    },
    normalisePath: function(path)
    {
        var normalisedPath = jQuery.trim(path);
        if (normalisedPath.charAt(0) == '/')
        {
            normalisedPath = normalisedPath.substring(1);
        }
        if (normalisedPath.charAt(normalisedPath.length - 1) == '/')
        {
            normalisedPath = normalisedPath.substring(0, normalisedPath.length - 1);
        }
        return normalisedPath;
    },
    topBar: function(fisheyeBaseUrl, repository, path, title)
    {
        var breadCrumb = function(path, label)
        {
            return jQuery("<a href=\"" + fisheyeBaseUrl + "browse/" + path + "\">" + label + "</a>");
        };
        var topBarDiv = jQuery("<div></div>").addClass("fisheye-chart-topbar");
        var breadCrumbs = jQuery("<span></span>").addClass("fisheye-chart-breadcrumbs");
        breadCrumbs.append("<span class=\"breadcrumbs-title\">" + title + ":</span>");
        topBarDiv.append(breadCrumbs);
        breadCrumbs.append(breadCrumb(repository, repository)).append(":/");
        var normalisedPath = AJS.fisheyeGadgets.normalisePath(path);
        if (normalisedPath.length > 0)
        {
            var pathComponents = normalisedPath.split("/");
            var p = repository;
            for (var i in pathComponents)
            {
                p += "/" + pathComponents[i];
                breadCrumbs.append(breadCrumb(p, pathComponents[i])).append("/");
            }
        }
        return topBarDiv;
    }
};