define('jira-webhooks/entities/transition-model', ['backbone'], function (Backbone) {
    'use strict';

    return Backbone.Model.extend({});
});

define('jira-webhooks/entities/transition-collection', ['jira-webhooks/entities/transition-model', 'wrm/context-path', 'backbone'], function (TransitionModel, wrmContextPath, Backbone) {
    'use strict';

    var contextPath = wrmContextPath();

    return Backbone.Collection.extend({
        initialize: function initialize(options) {
            this.selectionModel = options.selectionModel;
        },
        url: function url() {
            var webhookId = this.selectionModel.getSelected().get("self").split("/").splice(-1)[0];
            return contextPath + "/rest/jira-webhook/1.0/jira-webhook/" + webhookId + "/transitions";
        },
        model: TransitionModel
    });
});

define('jira-webhooks/entities/transition-item-view', ['jira/util/formatter', 'jira/util/strings', 'wrm/context-path', 'backbone', 'jquery'], function (formatter, strings, wrmContextPath, Backbone, $) {
    'use strict';

    var contextPath = wrmContextPath();

    return Backbone.View.extend({
        tagName: 'li',
        render: function render() {
            var unescapedWorkflowName = this.model.get("workflow");
            var workflowName = strings.escapeHtml(unescapedWorkflowName);
            var transitionName = strings.escapeHtml(this.model.get("transition"));
            var workflowLink = $("<a></a>").attr("href", contextPath + "/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=live&workflowName=" + unescapedWorkflowName).html(workflowName).wrap("<div></div>").parent().html();
            this.$el.append(formatter.I18n.getText("webhooks.transition", transitionName, workflowLink));
        }
    });
});

define('jira-webhooks/entities/transitions-view', ['jira-webhooks/entities/transition-item-view', 'jira/util/formatter', 'backbone', 'jquery'], function (TransitionView, formatter, Backbone, $) {
    'use strict';

    return Backbone.View.extend({
        el: "#webhook-transitions",
        initialize: function initialize() {
            this.model.selectionModel.onSelectionChange(this.selectionChanged, this);
        },
        render: function render() {
            var that = this;
            this.$el.empty();
            if (this.model.length === 0) {
                var noTransitionsMessage = $("<span></span>").text(formatter.I18n.getText("webhooks.transitions.notransitions"));
                this.$el.append(noTransitionsMessage);
            }

            this.model.each(function (model) {
                var transitionView = new TransitionView({ model: model });
                transitionView.render();
                that.$el.append(transitionView.$el);
            });
        },
        selectionChanged: function selectionChanged(selectionModel, selectedModel) {
            if (selectedModel && typeof selectedModel.get("self") !== "undefined") {
                var that = this;
                this.model.fetch({
                    success: function success() {
                        that.render();
                    }
                });
            } else {
                this.model.reset();
                this.render();
            }
        }
    });
});