UPM.define('ProgressDialog', [
    'UpmDialog'
], function (UpmDialog) {


    'use strict';


    return UpmDialog.extend({

        template: com.atlassian.upm.application.progressDialog,

        _initEvents: function () {
            this.listenTo(this.model, 'change:progressPercent', this._onChangeProgressPercent);
            this.listenTo(this.model, 'change:indeterminate', this._onChangeIndeterminate);
        },

        _postInitialize: function () {
            this.progressBar = this.$el.find('.aui-progress-indicator');
        },

        _onChangeIndeterminate: function () {
            if (this.model.getIndeterminate()) {
                AJS.progressBars.setIndeterminate(this.progressBar);
            } else {
                this.updateProgress(this.model.getProgressPercent());
            }
        },

        _onChangeProgressPercent: function () {
            this.updateProgress(this.model.getProgressPercent());
        },

        updateProgress: function (value) {
            AJS.progressBars.update(this.progressBar, value);
        },

        finishProgress: function () {
            if (!this.model.getIndeterminate() && this.value < 1) {
                this.updateProgress(1);
            }
            setTimeout(_.bind(function () {
                this.deferredResult.resolve();
                this.close();
            }, this), 300);
        }
    });
});