UPM.define('PlatformUpdateDialog', [
    'underscore',
    'UpmDialog',
    'UpmAnalytics'
], function (_,
             UpmDialog,
             UpmAnalytics) {


    'use strict';


    return UpmDialog.extend({

        template: com.atlassian.upm.application.platformUpdateDialog,

        _getData: function() {
            return {
                platformApp: this.model.toJSON(),
                updatableApps: this.options.updatableApps
            };
        },

        _postShow: function () {
            UpmAnalytics.logEvent('manageapps-update-platform-show');
        },

        _isSelected: function (app) {
            return app.required || app.platform || this.$el.find('#bundled-update-' + app.key).is(':checked');
        },

        _logAllAppAnalytics: function (dialogConfirmed) {
            var self = this,
                submit = dialogConfirmed ? 'submit' : 'cancel',
                dialogKey = 'manageapps-update-platform-' + submit,
                analyticsKey = 'manageapps-update-platform-app-' + submit,
                updates = _.map(this.options.updatableApps.concat([ this.model.toJSON() ]), function (app) {
                    return {
                        appKey: app.key,
                        selected: self._isSelected(app),
                        required: !!(app.require || app.platform),
                        version: app.platform && app.update ? app.update.updateVersion : app.updateVersion
                    };
                });

            UpmAnalytics.logEvent(dialogKey);
            _.each(updates, function (update) {
                UpmAnalytics.logEvent(analyticsKey, update);
            });
        },

        _getReturnValue: function() {
            var self = this;
            return _.pluck(_.filter(this.options.updatableApps, function (app) {
                return self._isSelected(app);
            }), 'key');
        },

        _onConfirm: function () {
            this._logAllAppAnalytics(true);
            UpmDialog.prototype._onConfirm.apply(this);
        },

        _onCancel: function () {
            this._logAllAppAnalytics(false);
            UpmDialog.prototype._onCancel.apply(this);
        }
    });
});