UPM.define('InlineDialogViewMixin', [
    'underscore'
], function (_) {

    'use strict';

    return {
        /**
         * Creates an AUI inline dialog bound to onClick to this view's element(s)
         * matching the provided selector.
         * @param selector. Selector to the element found in the view
         * @param id. Id that will be applied to the inline dialog element
         * @param dialogContent. HTML content for the inline dialog
         * @param dialogOptions. Options for the AUI InlineDialog method
         */
        inlineDialog: function (selector, id, dialogContent, dialogOptions) {

            var defaults = {
                closeOnTriggerClick: true,
                hideDelay: 3000,
                width: 230,
                gravity: 'w'
            };

            var options = _.extend({}, defaults, dialogOptions),
                element = this.$el.find(selector),
                init = function (content, trigger, show) {
                    content.css({ padding: '20px' }).html(dialogContent);
                    show();
                };

            element.addClass('inline-dialog-info-trigger');
            AJS.InlineDialog(element, id, init, options);
        }
    };
});