UPM.define('BlanketableViewMixin', [
   'jquery',
   'brace'
], function ($,
             Brace) {

    'use strict';

    return {
        /**
         * Adds or removes an overlay element that grays out the container's contents and makes them unclickable.
         * @method setBlanketed
         * @param {Boolean} flag  True to add the overlay (if not already present), false to remove it (if present)
         * @param {String} selector  Optional JQuery selector specifying a sub-element of this view to use as the container 
         */
        setBlanketed: function(flag, selector) {
            var $el = selector ? this.$el.find(selector) : this.$el;
            if (flag) {
                if (!$el.find('.blanket').length) {
                    var $blanket = $('<div></div>').addClass('blanket')
                        .css('position', 'absolute')
                        .css('top', 0)
                        .css('left', 0)
                        .css('bottom', 0)
                        .css('right', 0)
                        .css('z-index', 99)
                        .css('background-color', 'rgba(255, 255, 255, 0.5');
                    $el.css('position', 'relative');
                    $el.prepend($blanket);
                }
            } else {
                $el.find('.blanket').remove();
            }
        }
    };
});