AJS.test.require(["com.atlassian.feedback.jira-feedback-plugin:button-resources-test"],function(){"use strict";var e={software:"13831",business:"13830",service_desk:"13832",unknown:"13833"},t={page_path:"customfield_16632",project_type_id:"customfield_16630",version:"customfield_10932"};module("jira/feedback/issue-collector",{setup:function(){this.Meta={get:sinon.stub()},this.projectData={getCurrentProjectType:sinon.stub()},this.fakeJquery=sinon.stub(),this.context=AJS.test.mockableModuleContext(),this.context.mock("jira/util/data/meta",this.Meta),this.context.mock("jira/api/projects",this.projectData),this.context.mock("jquery",this.fakeJquery),this.issueCollector=this.context.require("jira/feedback/issue-collector")}}),test("getProjectType should be able to get the projectType for software from Meta Data",function(){this.Meta.get.withArgs("issue-project-type").returns("software"),equal(this.issueCollector.getProjectType(),"software")}),test("getProjectType should be able to get the projectType for business from Meta Data",function(){this.Meta.get.withArgs("issue-project-type").returns("business"),equal(this.issueCollector.getProjectType(),"business")}),test("getProjectType should be able to get the projectType for service desk from Meta Data",function(){this.Meta.get.withArgs("issue-project-type").returns("service_desk"),equal(this.issueCollector.getProjectType(),"service_desk")}),test("getProjectType should return unknown for an unseen projectType",function(){this.Meta.get.withArgs("issue-project-type").returns("doge"),this.projectData.getCurrentProjectType.returns("doge"),equal(this.issueCollector.getProjectType(),"unknown")}),test("getProjectType should return unknown if the projectType is undefined",function(){this.Meta.get.withArgs("issue-project-type").returns(void 0),this.projectData.getCurrentProjectType.returns(void 0),equal(this.issueCollector.getProjectType(),"unknown")}),test("getProjectType should return unknown if the projectType is an empty string",function(){this.Meta.get.withArgs("issue-project-type").returns(""),this.projectData.getCurrentProjectType.returns(""),equal(this.issueCollector.getProjectType(),"unknown")}),test("getProjectType should be able to get the projectType for software from Project Sidebar",function(){this.Meta.get.withArgs("issue-project-type").returns(void 0),this.projectData.getCurrentProjectType.returns("software"),equal(this.issueCollector.getProjectType(),"software")}),test("getProjectType should be able to get the projectType for business from Project Sidebar",function(){this.Meta.get.withArgs("issue-project-type").returns(void 0),this.projectData.getCurrentProjectType.returns("business"),equal(this.issueCollector.getProjectType(),"business")}),test("getProjectType should be able to get the projectType for service_desk from Project Sidebar",function(){this.Meta.get.withArgs("issue-project-type").returns(void 0),this.projectData.getCurrentProjectType.returns("service_desk"),equal(this.issueCollector.getProjectType(),"service_desk")}),test("getProjectTypeID should map service desk to projectTypeId",function(){this.issueCollector.getProjectType=function(){return"service_desk"},equal(this.issueCollector.getProjectTypeId(),e.service_desk)}),test("getProjectTypeID should map business to projectTypeId",function(){this.issueCollector.getProjectType=function(){return"business"},equal(this.issueCollector.getProjectTypeId(),e.business)}),test("getProjectTypeID should map software to projectTypeId",function(){this.issueCollector.getProjectType=function(){return"software"},equal(this.issueCollector.getProjectTypeId(),e.software)}),test("getProjectTypeID should map an incorrect projectType to unknown",function(){this.issueCollector.getProjectType=function(){return"doge"},equal(this.issueCollector.getProjectTypeId(),e.unknown)}),test("getJiraVersion should return the jira version provided by Meta",function(){this.Meta.get.withArgs("version-number").returns("7.1.0-OD-03-038"),equal(this.issueCollector.getJiraVersion(),"7.1.0-OD-03-038")}),test('getJiraVersion should return "non detected" if Meta does not have the information',function(){this.Meta.get.withArgs("version-number").returns(void 0),equal(this.issueCollector.getJiraVersion(),"not detected")}),test("getFieldValues should call getJiraVersion, getProjectTypeId and getPath",function(){var e=sinon.spy(this.issueCollector,"getJiraVersion"),t=sinon.spy(this.issueCollector,"getProjectTypeId"),s=sinon.spy(this.issueCollector,"getPath");this.issueCollector.getFieldValues(),ok(e.calledOnce),ok(t.calledOnce),ok(s.calledOnce)}),test("getFieldValues should assign the version, projectTypeId and path correctly to the custom field",function(){this.issueCollector.getPath=function(){return"some/path/"},this.issueCollector.getProjectTypeId=function(){return"43"},this.issueCollector.getJiraVersion=function(){return"jira-version-123"};var e=this.issueCollector.getFieldValues();equal(e[t.page_path],"some/path/"),equal(e[t.project_type_id],"43"),equal(e[t.version],"jira-version-123")})});