(function () {
    /*global test, equal, ok, sinon*/
    'use strict';

    var $ = require('jquery');
    var FileViewer = require('file-viewer');
    var File = require('file');
    var ButtonYoutube = require('video-view/button-youtube');

    var noop = function (ret) {
        return ret;
    };
    var createPlayerMock = function () {
        return {
            language: noop,
            languages: noop,
            pause: noop,
            src: noop.bind(this, ''),
            currentTime: noop.bind(this, 0)
        };
    };

    var createFileViewerMock = function (analyticsBackend, file, hasher) {
        var fileViewer = new FileViewer({analyticsBackend: analyticsBackend});
        fileViewer.getView().getViewState = sinon.stub().returns('success');
        fileViewer.getCurrentFile = sinon.stub().returns(file);
        fileViewer.analytics._hasher = hasher;
        return fileViewer;
    };

    module('ButtonYoutube');

    test('it triggers an analytics event on click', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var hasher = function (x) { return x.toUpperCase(); };

        var fileViewer = createFileViewerMock(analyticsBackend, file, hasher);
        var player = createPlayerMock();

        var btn = new ButtonYoutube({player: player, fileViewer: fileViewer});

        // when
        sinon.stub(window, 'open');
        $(btn.el_).click();
        window.open.restore();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.gotoyoutube');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

}());
