/* Copyright 2012 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Extracted from PDFJS viewer.js by Atlassian to be AMD compatible
 * and to remove unneeded features
 */
define('pdf-viewer/viewer-properties',
  [],
  function () {
    return {
      DEFAULT_SCALE: 'auto',
      DEFAULT_SCALE_PRESENTATION: 'page-fit',
      DEFAULT_SCALE_DELTA: 1.1,
      DEFAULT_CACHE_SIZE: 10,
      UNKNOWN_SCALE: 0,
      CSS_UNITS: 96.0 / 72.0,
      SCROLLBAR_PADDING: 40,
      VERTICAL_PADDING: 20,
      NAVIGATION_ARROW_PADDING: 160,
      MAX_AUTO_SCALE: 1.25,
      MIN_SCALE: 0.25,
      MAX_SCALE: 4.0,
      USE_ONLY_CSS_ZOOM: false,
      CLEANUP_TIMEOUT: 30000,
      IGNORE_CURRENT_POSITION_ON_ZOOM: false,
      RENDER_DELAY: 200, // ms
      MAX_TEXT_DIVS_TO_RENDER: 100000
    };
  });
