define('pdf-view-provider', [
  'jquery',
  'file',
  'module-store-singleton'
], function (
  $,
  File,
  moduleStore
) {
  'use strict';

  var asyncViewerResource = null,
    asyncConfigResource = null;

  /**
   * Returns a pdf viewer.
   * @returns {Promise}
   */
  var pdfViewProvider = function () {
    if (!asyncViewerResource) {
      asyncViewerResource = moduleStore.get('pdf-viewer');
    }
    if (!asyncConfigResource) {
      asyncConfigResource = moduleStore.get('pdf-config');
    }

    var viewerInstance = $.Deferred();

    $.when(asyncViewerResource, asyncConfigResource).done(function (viewer, config) {
      var PDFViewer = require('pdf-view');

      // FIL-1811: Use UMD for loading PDFJS
      var PDFJS = window.PDFJS;
      PDFJS.workerSrc = config.workerSrc;
      PDFJS.cMapUrl = config.cMapUrl;

      viewerInstance.resolve(PDFViewer);
    });

    return viewerInstance.promise();
  };

  return pdfViewProvider;
});
