(function () {
  /*global sinon, test, equal, ok*/
  'use strict';

  var $ = require('jquery');

  var FileViewer = require('file-viewer');
  var ImageView = require('image-view');
  var noop = function () {};

  var createFileViewerMock = function () {
      var fileViewer = new FileViewer({});
      return fileViewer;
  };

  module('ImageView');

  test('#.pixelateIfScaleOverThreshold() removes .pixelate class to image if zoom scale is < 2' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer,
    });

    view.$image = $('<img id="cp-img" class="pixelate">');

    // when
    view.pixelateIfScaleOverThreshold(1);

    // then
    equal(view.$image.hasClass('pixelate'), false);
  });

  test('#.pixelateIfScaleOverThreshold() adds .pixelate class to image if zoom scale is >= 2' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer,
    });

    view.$image = $('<img id="cp-img">');

    // when
    view.pixelateIfScaleOverThreshold(2);

    // then
    equal(view.$image.hasClass('pixelate'), true);
  });

  test('#._stopFit() sets #._isFitWidth & #._isFitHeight to false' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer,
    });

    view._isFitWidth = true;
    view._isFitHeight = true;

    // when
    view._stopFit();

    // then
    equal(view._isFitWidth, false);
    equal(view._isFitHeight, false);
  });

  test('#._isImageBiggerThanViewport() reports correct relation of image to viewport' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer,
    });

    view.imageWidth = 800;
    view.imageHeight = 500;

    sinon.stub(view.$el, 'width').returns(600);
    sinon.stub(view.$el, 'height').returns(600);

    // then
    equal(view._isImageBiggerThanViewport(), true);
    equal(view._isImageWiderThanViewport(), true);
    equal(view._isImageHigherThanViewport(), false);
  });

  test('#.zoomWidth() calls #.changeScale() with correct scale' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view.changeScale = noop;
    sinon.spy(view, 'changeScale');

    view.imageWidth = 100;
    view.imageHeight = 200;

    sinon.stub(view.$el, 'width').returns(200);
    sinon.stub(view.$el, 'height').returns(100);

    // when
    view.zoomWidth();

    //then
    ok(view.changeScale.calledWith(2));
    equal(view._isFitWidth, true);
    equal(view._isFitHeight, false);
  });

  test('#.zoomHeight() calls #.changeScale() with correct scale' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view.changeScale = noop;
    sinon.spy(view, 'changeScale');

    view.imageWidth = 100;
    view.imageHeight = 200;

    sinon.stub(view.$el, 'width').returns(200);
    sinon.stub(view.$el, 'height').returns(100);

    // when
    view.zoomHeight();

    //then
    ok(view.changeScale.calledWith(0.5));
    equal(view._isFitWidth, false);
    equal(view._isFitHeight, true);
  });

  test('#.zoomAuto() calls #.changeScale() with correct scale for portraits' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view.changeScale = noop;

    sinon.spy(view, 'changeScale');

    view.imageWidth = 100;
    view.imageHeight = 200;

    sinon.stub(view.$el, 'width').returns(200);
    sinon.stub(view.$el, 'height').returns(100);

    // when
    view.zoomAuto();

    //then
    ok(view.changeScale.calledWith(0.5));
    equal(view._isFitWidth, false);
    equal(view._isFitHeight, true);
  });

  test('#.zoomAuto() calls #.changeScale() with correct scale for landscapes' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view.changeScale = noop;

    sinon.spy(view, 'changeScale');

    view.imageWidth = 800;
    view.imageHeight = 200;

    sinon.stub(view.$el, 'width').returns(200);
    sinon.stub(view.$el, 'height').returns(100);

    // when
    view.zoomAuto();

    //then
    ok(view.changeScale.calledWith(0.25));
    equal(view._isFitWidth, true);
    equal(view._isFitHeight, false);
  });

  test('#.zoomAuto() calls #._zoomPageFit() if image > viewport' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view._zoomPageFit = noop;
    sinon.spy(view, '_zoomPageFit');
    sinon.stub(view, '_isImageBiggerThanViewport').returns(true);

    // when
    view.zoomAuto();

    //then
    ok(view._zoomPageFit.calledOnce);
  });

  test('#.zoomAuto() calls #._zoomPageFit() if image < viewport' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view.zoomActual = noop;
    sinon.spy(view, 'zoomActual');
    sinon.stub(view, '_isImageBiggerThanViewport').returns(false);

    // when
    view.zoomAuto();

    //then
    ok(view.zoomActual.calledOnce);
  });

  test('#.zoomAuto(true) calls #._zoomPageFit() regardless of the image size' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view._zoomPageFit = noop;
    sinon.spy(view, '_zoomPageFit');

    // when
    view.zoomAuto(true);

    //then
    ok(view._zoomPageFit.calledOnce);
  });

  test('#.zoomFit() calls #.zoomActual() when image was page fit' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view.$image = $('<img id="cp-img" class="pixelate">');

    view.zoomActual = noop;

    sinon.spy(view, 'zoomActual');

    view.imageWidth = 800;
    view.imageHeight = 200;

    sinon.stub(view.$el, 'width').returns(200);
    sinon.stub(view.$image, 'width').returns(200);
    sinon.stub(view.$el, 'height').returns(100);
    sinon.stub(view.$image, 'height').returns(100);

    // when
    view.zoomFit();

    //then
    ok(view.zoomActual.calledOnce);
  });

  test('#.zoomFit() calls #.zoomAuto(true) when image was zoomed to 100%' , function () {

    // given
    var fileViewer = createFileViewerMock();
    var view = new ImageView({
        fileViewer: fileViewer
    });

    view.$image = $('<img id="cp-img" class="pixelate">');

    view.zoomAuto = noop;

    sinon.spy(view, 'zoomAuto');

    sinon.stub(view.$el, 'width').returns(400);
    sinon.stub(view.$image, 'width').returns(200);

    sinon.stub(view.$el, 'height').returns(200);
    sinon.stub(view.$image, 'height').returns(100);

    // when
    view.zoomFit();

    //then
    ok(view.zoomAuto.calledWith(true));
  });

}());
