(function () {
    /*global test, equal*/
    'use strict';

    var fileTypes = require('file-types');

    module('file-types');

    test('fileTypes lowercase conversion does work', function () {
        equal(fileTypes.isPDF('application/PDF'), true);
        equal(fileTypes.isPDF('application/Pdf'), true);
        equal(fileTypes.isPDF('application/pdf'), true);
        equal(fileTypes.isPDF('APPLICATION/pdf'), true);
    });

    test('#isYoutube() returns true on youtube mimetype', function () {
        equal(fileTypes.isYoutube('video/youtube'), true);
    });

    test('#isYoutube() returns false on other mimetypes', function () {
        equal(fileTypes.isPDF('///'), false);
        equal(fileTypes.isPDF('video//youtube'), false);
        equal(fileTypes.isPDF('text/html'), false);
        equal(fileTypes.isPDF('aplpication/pdf'), false);
    });

}());
