(function () {
    'use strict';

    var urlHelper = require('url');

    module('url');

    test('#addQueryParamToUrl() adds query param to an URL', function () {
        var url, param, result;

        url   = 'http://example.com/path/file?query=true';
        param = { 'some': 'data' };
        result = urlHelper.addQueryParamToUrl(url, param);

        // then
        equal(result, 'http://example.com/path/file?query=true&some=data');
    });

    test('#addQueryParamToUrl() returns original URL when param object is empty', function () {
        var url, param, result;

        url   = 'http://example.com/path/file';
        param = {};
        result = urlHelper.addQueryParamToUrl(url, param);

        // then
        equal(result, url);
    });

    test('#addQueryParamToUrl() returns original URL when param object is undefined', function () {
        var url, result;

        url   = 'http://example.com/path/file';
        result = urlHelper.addQueryParamToUrl(url);

        // then
        equal(result, url);
    });

}());
