(function () {
    'use strict';

    var TemplateStore = require('template-store');

    module('TemplateStore', {
        setup: function () {
            this.templateStore = new TemplateStore();
        }
    });

    test('validBackend() returns true for functions', function () {
        var backend = function () {};
        equal(TemplateStore.validBackend({}), false, 'object is not valid');
        equal(TemplateStore.validBackend(backend), true, 'function is valid');
    });

    test('#get() asks the registered backend for the template', function () {
        var tpl = function () {};
        var backend = sinon.stub().returns(tpl);

        this.templateStore.useBackend(backend);

        equal(this.templateStore.get('tpl'), tpl, 'returns correct template');

        ok(backend.calledOnce, 'backend called');
        equal(backend.args[0][0], 'tpl', 'called with template path');
    });

    test('#get() throws if no backend is set', function () {
        throws(function () {
            this.templateStore.get('any');
        }.bind(this), 'no backend is set');
    });

    test('#useBackend() throws if backend is invalid', function () {
        throws(function () {
            this.templateStore.useBackend(null);
        }.bind(this), 'null is not a backend');
    });

}());
