define('watermark/watermarkPlugin', [
  'backbone',
  'template-store-singleton'
], function (
  Backbone,
  templateStore
) {
  'use strict';

  /**
   * Displays a watermark image if enabled in config, to use it,
   * set the following properties
   *
   * watermark: {
   *     imgSrc: 'url_to_image',
   *     linkUrl: 'url_to_open_when_clicked_on_image'
   * }
   */
  var watermarkPlugin = function (fileViewer) {
    if (!fileViewer.getConfig().watermark) { return; }

    var watermarkView = Backbone.View.extend({
      render: function () {
        this.$el.append(templateStore.get('watermarkImage')({
          img: fileViewer.getConfig().watermark.imgSrc,
          url: fileViewer.getConfig().watermark.linkUrl
        }));
        return this;
      }
    });

    fileViewer.getView().fileContentView.addLayerView(
      'watermarkImage',
      watermarkView
    );
  };

  return watermarkPlugin;
});
