define('minimode/ThumbnailView',
  [
    'ajs',
    'backbone',
    'jquery',
    'underscore',
    'file-types',
    'icon-utils',
    'template-store-singleton'
  ],
  function (
    AJS,
    Backbone,
    $,
    _,
    fileTypes,
    iconUtils,
    templateStore
  ) {
    'use strict';

    var ThumbnailView = Backbone.View.extend({

      className: 'cp-thumbnail',

      tagName: 'li',

      events: {
        'click' : 'jumpToFile'
      },

      initialize: function (options) {
        this._fileViewer = options.fileViewer;
        this.listenTo(this.model, 'change', this.render);
        this.listenTo(options.panelView, 'renderPanel', this.setSelected);
      },

      jumpToFile: function (event) {
        event.preventDefault();

        this._fileViewer.showFileWithCID(this.model.cid)
        .then(function () {
          var contentView = this._fileViewer.getView().fileContentView;
          var currentViewer;
          if (contentView.isLayerInitialized('content')) {
            currentViewer = contentView.getLayerForName('content')._viewer;
            currentViewer && currentViewer.play && currentViewer.play();
          }
        }.bind(this))
        .always(
          this._fileViewer.analytics.fn('files.fileviewer-web.minimode.thumbnail.clicked')
        );
      },

      setSelected: function () {
        // this may not be the same as file being shown, e.g., a different version of file is shown
        var file = this._fileViewer._fileState.getCurrent();
        if (file === this.model) {
          this.$el.addClass('selected');
        } else if (this.$el.hasClass('selected')) {
          this.$el.removeClass('selected');
        }
      },

      onThumbLoadError: function (ev) {
        var el = $(ev.target);
        el.parent().removeClass('has-thumbnail');
        el.remove();
      },

      render: function () {
        var type = this.model.get('type'),
          thumbnailSrc = this.model.get('thumbnail'),
          isImage = fileTypes.isImage(type);

        var generateThumbnail = this._fileViewer.getConfig().generateThumbnail;

        var $thumbnail = $(templateStore.get('placeholderThumbnail')({
          iconClass: iconUtils.getCssClass(type),
          title: this.model.get('title')
        }));

        this.$el.empty().append($thumbnail);

        if (thumbnailSrc && generateThumbnail) {
          generateThumbnail(this.model).done(function (thumbSrc) {
            $thumbnail.replaceWith(templateStore.get('thumbnail')({
              iconClass: iconUtils.getCssClass(type),
              thumbnailSrc: thumbSrc,
              title: this.model.get('title')
            }));
            this.$el.find('img').error(this.onThumbLoadError);
          }.bind(this));
        } else if (isImage || thumbnailSrc) {
          $thumbnail.replaceWith(templateStore.get('thumbnail')({
            iconClass: iconUtils.getCssClass(type),
            thumbnailSrc: thumbnailSrc || this.model.get('src'),
            title: this.model.get('title')
          }));
          this.$el.find('img').error(this.onThumbLoadError);
        }

        return this;
      }

    });

    return ThumbnailView;
  });
