define('minimode/minimodePlugin', [
  'minimode/MinimodeToggle',
  'minimode/MinimodePanel'
], function (
  MinimodeToggle,
  MinimodePanel
) {
  'use strict';

  var minimodePlugin = function (fileViewer) {
    var fileView = fileViewer.getView();
    var sinkView = fileView.fileSinkView;
    var metaView = fileView.fileMetaView;

    if (!fileViewer.getConfig().enableMiniMode) {
      return;
    }

    metaView.addLayerView('minimodeToggle', MinimodeToggle, {
      predicate: MinimodeToggle.predicate
    });
    sinkView.addPanelView('minimode', MinimodePanel);
  };

  return minimodePlugin;
});