(function () {
    'use strict';

    var _ = require('underscore');
    var Backbone = require('backbone');
    var FileViewer = require('file-viewer');
    var Files = require('files');
    var File = require('file');
    var PanelContainerView = require('panel-container-view');
    var MinimodePanel = require('minimode/MinimodePanel');

    module('MinimodePanel view unit tests', {
        setup: function() {
            var model1 = new File({
                src: 'base/src/test/resources/image/pug500.png',
                thumbnail: 'base/src/test/resources/image/pug50.png',
                title: 'kitten 1',
                type: 'image'
            });
            var model2 = new File({
                src: 'base/src/test/resources/image/pug300.png',
                thumbnail: 'base/src/test/resources/image/pug50.png',
                title: 'kitten 2',
                type: 'image'
            });

            this.collection = new Files();
            this.collection.add(model1);
            this.collection.add(model2);
            this.panelView = _.extend({}, Backbone.Events);

            this.view = new MinimodePanel({
                collection: this.collection,
                panelView: this.panelView,
                fileViewer: new FileViewer({})
            });
        }
    });

    test('Test correct thumbnails are rendered', function(assert) {
        expect(3);
        this.view.render();
        assert.equal(this.view.$el.find('#cp-thumbnails').length, 1);
        assert.equal(this.view.subviews.length, 2);
        assert.equal(this.view.$el.find('.cp-thumbnail').length, 2);
    });

    test('Test can close old subviews', function(assert) {
        expect(1);
        this.view.closeOldSubviews();
        assert.equal(this.view.subviews.length, 0);
    });

    module('MinimodePanel events integration tests', {
        setup: function() {
            var model1 = new File({
                src: 'base/src/test/resources/image/pug500.png',
                thumbnail: 'base/src/test/resources/image/pug50.png',
                title: 'kitten 1',
                type: 'image'
            });
            var model2 = new File({
                src: 'base/src/test/resources/image/pug300.png',
                thumbnail: 'base/src/test/resources/image/pug50.png',
                title: 'kitten 2',
                type: 'image'
            });

            this.collection = new Files();
            this.collection.add(model1);
            this.collection.add(model2);
            this.panelView = _.extend({ collection: this.collection }, Backbone.Events);
        }
    });

    test('Test chrome repaint forced', function() {
        expect(1);
        sinon.stub(MinimodePanel.prototype, '_forceChromeRepaint');
        this.view = new MinimodePanel({ collection: this.collection, panelView: this.panelView, fileViewer: new FileViewer({}) });

        this.panelView.trigger('renderPanel', 'minimode', true);
        ok(this.view._forceChromeRepaint.calledOnce, 'Chrome repaint was not triggered');

        MinimodePanel.prototype._forceChromeRepaint.restore();
    });


    test('Test minimode re-rendered on collection change', function() {
        expect(1);
        sinon.stub(MinimodePanel.prototype, 'render');
        this.view = new MinimodePanel({ collection: this.collection, panelView: this.panelView });

        this.collection.trigger('add');
        this.collection.trigger('reset');
        ok(this.view.render.calledTwice, 'Render was not triggered the correct number of times');

        MinimodePanel.prototype.render.restore();
    });
}());
