(function () {
    'use strict';

    var metabarView = require('metabar/metabarView');

    module('MetaBarView', {
        setup: function () {
            this.config = {
                 metaBar: {
                    defaultAvatar: 'example'
                }
            };
            this.meta = {
                author: 'this._meta.author',
                date: 'this._meta.date'
            };
            this.fileViewer = {
                getConfig: function () {
                    return this.config;
                }.bind(this),
                getCurrent: function () {
                    return {
                        meta: this.meta
                    };
                }.bind(this)
            };
        },
    });

    test('#predicate() returns true if `config.metaBar`, `meta.author` and `meta.date` exist', function(assert) {
        expect(1);
        assert.equal(metabarView.predicate(this.fileViewer), true);
    });

    test('#predicate() returns false if `config.metaBar` does not exist', function(assert) {
        this.config.metaBar = null;
        expect(1);
        assert.equal(metabarView.predicate(this.fileViewer), false);
    });

    test('#predicate() returns false if `meta.author` does not exist', function(assert) {
        this.meta.author = null;
        expect(1);
        assert.equal(metabarView.predicate(this.fileViewer), false);
    });

    test('#predicate() returns false if `meta.date` does not exist', function(assert) {
        this.meta.date = null;
        expect(1);
        assert.equal(metabarView.predicate(this.fileViewer), false);
    });

}());
