define('TitleView', [
  'backbone', 'icon-utils', 'template-store-singleton'
], function (Backbone, iconUtils, templateStore) {
  'use strict';

  var TitleView = Backbone.View.extend({

    initialize: function (options) {
      this._fileViewer = options.fileViewer;
    },

    render: function () {
      var model = this._fileViewer.getCurrentFile();
      if (!model) { return; }

      this.$el.html(templateStore.get('titleContainer')({
        title: model.get('title'),
        iconClass: iconUtils.getCssClass(model.get('type'))
      }));

      return this;
    }

  });

  return TitleView;
});