define('soy-template-backend', [], function () {
  'use strict';

  /* global FileViewer */
  // FileViewer is defined in support/wrapper-plugin-footer.js

  // Returns a value from a nested object, example:
  // obj = { a: { b: { c: 'x' } } }
  // getNestedProperty(obj, 'a.b.c') -> 'x'
  var getNestedProperty = function (obj, prop) {
    var levels = prop.split('.');
    var i;
    for (i = 0; i < levels.length; i++) {
      obj = obj[levels[i]];
    }
    return obj;
  };

  return function (fileViewer) {
    /**
     * Picks the specified template url from the auto-generated template object.
     * @param {string} templateUrl
     * @return {function}
     */
    return function (templateUrl) {
      return getNestedProperty(FileViewer.Templates, templateUrl);
    };
  };
});
