(function () {
    'use strict';

    var $ = require('jquery');
    var ArrowLayer = require('ArrowLayer');
    var FileViewer = require('file-viewer');
    var File = require('file');
    var Files = require('files');

    module('ArrowLayer');

    test('#gotoNext() delegates call', function () {
        var fileViewer = new FileViewer({appendTo:$('<div>')});
        fileViewer.open();
        var view = new ArrowLayer({
            fileViewer: fileViewer
        });
        sinon.spy(fileViewer, 'showFile');
        view.gotoNext();
        ok (fileViewer.showFile.calledOnce, 'fileState has been updated');
    });

    test('#gotoPrev() delegates call', function () {
        var fileViewer = new FileViewer({appendTo:$('<div>')});
        fileViewer.open();
        var view = new ArrowLayer({
            fileViewer: fileViewer
        });
        sinon.spy(fileViewer, 'showFile');
        view.gotoPrevious();
        ok (fileViewer.showFile.calledOnce, 'fileState has been updated');
    });

    test('pressing the right arrow sends an analytics event for the next file', function () {
        // given
        var file = {src: 'test', type:'test/example'};
        var otherFile = {src: 'other', type:'other/example'};
        var hasher = function (x) { return x.toUpperCase() };
        var backend = sinon.spy();
        var fileViewer = new FileViewer({ analyticsBackend:backend, appendTo: $('<div>') });
        fileViewer.analytics._hasher = hasher;

        // when
        fileViewer.open();
        fileViewer.updateFiles([file, otherFile]);
        fileViewer.showFileWithQuery({src: otherFile.src});
        fileViewer.getView().$('#cp-nav-right').click();

        // then
        ok(backend.calledOnce);
        var key = backend.args[0][0];
        var data = backend.args[0][1];
        equal(key, 'files.fileviewer-web.next');
        equal(data.actionType, 'button');
        equal(data.fileType, file.type);
        equal(data.fileId, hasher(file.src));
        equal(data.fileState, 'success');
    });

    test('pressing the left arrow sends an analytics event for the prev file', function () {
        // given
        var file = {src: 'test', type:'test/example'};
        var otherFile = {src: 'other', type:'other/example'};
        var hasher = function (x) { return x.toUpperCase() };
        var backend = sinon.spy();
        var fileViewer = new FileViewer({ analyticsBackend:backend, appendTo: $('<div>') });
        fileViewer.analytics._hasher = hasher;

        // when
        fileViewer.open();
        fileViewer.updateFiles([file, otherFile]);
        fileViewer.showFileWithQuery({src: otherFile.src});
        fileViewer.getView().$('#cp-nav-left').click();

        // then
        ok(backend.calledOnce);
        var key = backend.args[0][0];
        var data = backend.args[0][1];
        equal(key, 'files.fileviewer-web.prev');
        equal(data.actionType, 'button');
        equal(data.fileType, file.type);
        equal(data.fileId, hasher(file.src));
        equal(data.fileState, 'success');
    });

}());
