define('MoreButton', [
  'jquery', 'underscore', 'backbone', 'template-store-singleton'
], function ($, _, Backbone, templateStore) {
  'use strict';

  var MoreButton = Backbone.View.extend({

    tagName: 'span',

    initialize: function (options) {
      this._fileViewer = options.fileViewer;
      this._fileActions = [];
    },

    render: function () {
      this.$el.html(templateStore.get('moreButton')());
      var $dropdown = this.$el.find('#cp-more-menu'),
        $menu = $dropdown.find('ul');

      // prevent the tooltip from showing when the menu is open
      $dropdown.on({
        'aui-dropdown2-show': function () {
          this.$('button').tipsy('disable');
        }.bind(this),
        'aui-dropdown2-hide': function () {
          this.$('button').tipsy('enable');
        }.bind(this)
      });

      var currentFile = this._fileViewer._fileState.getCurrent();

      this.$('button').tooltip({ gravity: 'n' });
      if (this._fileActions.length) {
        this._fileActions.forEach(function (item) {
          var $item = $(templateStore.get('moreMenuItem')({text: item.text}));
          $item.click(function (e) {
            e.preventDefault();
            item.callback(currentFile);
          });
          $menu.append($item);
        });
        this._show();
      } else {
        this._hide();
      }

      return this;
    },

    addFileAction: function (opts) {
      var match = _.findWhere(this._fileActions, {key: opts.key});

      if (match) {
        // overwrite the properties of the old action with the new ones
        _.extend(match, {
          key: opts.key,
          text: opts.text,
          callback: opts.callback
        });
      } else {
        this._fileActions.push({
          key: opts.key,
          text: opts.text,
          callback: opts.callback
        });
      }

      this.render();
    },

    removeFileAction: function (action) {
      var index = _.indexOf(this._fileActions, action);
      this._fileActions.splice(index, 1);

      this.render();
    },

    _show: function () {
      this.$el.css('display', 'inline');
    },

    _hide: function () {
      this.$el.css('display', 'none');
    }
  });

  return MoreButton;
});
