(function () {
    'use strict';

    var FileViewer = require('file-viewer');
    var File = require('file');
    var DownloadButton = require('DownloadButton');

    module('DownloadButton');

    test('sends an analytics event when clicked', function () {
        // given
        var file = new File({type: 'test/example', src:'test'});
        var analyticsBackend = sinon.spy();
        var fileViewer = new FileViewer({analyticsBackend:analyticsBackend});
        var downloadButton = new DownloadButton({fileViewer: fileViewer});
        var hasher = function (x) { return x.toUpperCase(); };

        fileViewer.getView().getViewState = sinon.stub().returns('success');
        fileViewer.getCurrentFile = sinon.stub().returns(file);
        fileViewer.analytics._hasher = hasher;

        // when
        downloadButton.$el.click();

        // then
        ok(analyticsBackend.calledOnce);
        var key = analyticsBackend.args[0][0];
        var data = analyticsBackend.args[0][1];

        equal(key, 'files.fileviewer-web.file.download');
        equal(data.actionType, 'button');
        equal(data.fileType, file.get('type'));
        equal(data.fileId, hasher(file.get('src')));
        equal(data.fileState, 'success');
    });

}());