define('DownloadButton', [
  'backbone', 'template-store-singleton'
], function (Backbone, templateStore) {
  'use strict';

  var DownloadButton = Backbone.View.extend({

    tagName: 'span',

    events: {
      'click': '_triggerAnalytics'
    },

    initialize: function (options) {
      this._fileViewer = options.fileViewer;
      this._model = this._fileViewer.getCurrentFile();
    },

    render: function () {
      this.$el.html(templateStore.get('controlDownloadButton')({
        src: this._model.get('srcDownload') || this._model.get('src')
      }));

      this.$('a').tooltip({ gravity: 'n' });

      return this;
    },

    _triggerAnalytics: function () {
      this._fileViewer.trigger('fv.download');
      this._fileViewer.analytics.send('files.fileviewer-web.file.download', {
        actionType: 'button'
      });
    }

  }, {
    isDownloadable: function (fileViewer) {
      var file = fileViewer.getCurrentFile();
      return file && file.get('downloadable');
    }
  });

  return DownloadButton;
});
