define('BaseViewer', [
  'jquery', 'underscore', 'backbone'
], function ($, _, Backbone) {
  'use strict';

  /**
   * Base class for viewers.
   * @constructor
   */
  var BaseViewer = Backbone.View.extend({

    // Event listeners specific to this view namespaced to prevent collisions with its children.

    contentViewEvents: {
      'click.contentView': '_clickedBackgroundToClose',
      'mousedown.contentView': '_mousedownContentView'
    },

    // Merge events with children's event object to bind all event handlers

    initialize: function (options) {
      this.events = _.extend(this.events || {}, this.contentViewEvents);

      this._fileViewer = options.fileViewer;
      this._previewSrc = options.previewSrc;
      this._mousedownBackground = null;
    },

    teardown: function () {},

    // Listen to clicks to the background and eventually close the fileViewer.
    //
    // A viewer can specify getBackground if their background element isn't their contents

    _mousedownContentView: function (e) {
      var $background = this.getBackground ? this.getBackground() : this.$el;
      this._mousedownBackground = $(e.target).is($background);
    },

    _clickedBackgroundToClose: function (e) {
      // @TODO: Remove after cleaning modes setup, hooks etc.
      var mode = this._fileViewer._view._modes[this._fileViewer._view._mode];
      if (mode.disableClickBackgroundCloses) {
        return;
      }
      var $background = this.getBackground ? this.getBackground() : this.$el;
      if (this._mousedownBackground && $(e.target).is($background)) {
        this._fileViewer.analytics.send('files.fileviewer-web.closed', {
          actionType: 'element'
        });
        this._fileViewer.close();
      }
    },

    // This function is called whenever the viewport of the viewer changes size,
    // e.g. when a panel is opened or closed. Overwrite this function if you want
    // custom behaviour.
    handleResize: function () {}

  });

  return BaseViewer;
});
