define('asset-module-backend', [], function () {
  'use strict';

  return function (fileViewer) {

    /**
     * Assumes that all modules are included as static assets and therefore
     * already loaded. Uses FileViewer.getConfig().assets for the
     * module configuration.
     *
     * @param {String} moduleName
     * @return {Promise}
     */

    return function (moduleName) {
      if (moduleName === 'pdf-config') {
        return fileViewer.getConfig().assets['pdf-config'] || {};
      }
    };
  };

});