define('defaultConfig', [], function () {
  /**
   * FileViwers configuration options:
   *
   * - appendTo {DOMNode} [$('body')] - DOM Element to append to
   * - files {Array} - An array of file objects
   * - commentService {Object} - Comments service
   * - templateBackend {Function} - Provides templates for a given name
   * - moduleBackend {Function} - Provides modules for a given name
   * - pdfTransportFactory {Function} - cb(currentFile):Promise<PDFTransport>
   * - enableListLoop {Boolean} [true] - Allow to navigate from end to start of file list and v.v.
   * - enablePresentationMode {Boolean} [true] - Allow switching to presentation mode
   * - preloadImagesAfterCurrent {Number} [2] - Files after current to preload if they are images.
   * - preloadImagesBeforeCurrent {Number} [0] - Files before current to preload if they are images.
   * - videoDefaultQualityHd {Boolean} [true] - By default play HD content if available
   * - customStorage {Object} [null] - Custom storage object with setItem, getItem, removeItem methods
   *
   * @exports defaultConfig
   */
  return {
    enableListLoop: true,
    enablePresentationMode: true,
    preloadImagesAfterCurrent: 2,
    preloadImagesBeforeCurrent: 0,
    videoDefaultQualityHd: true,
    customStorage: null,
    viewers: ['image', 'document', 'video', '3d'],
    embedded: false
  };
});
