// Karma configuration
// Generated on Fri Jan 09 2015 14:46:26 GMT+1100 (AEDT)

module.exports = function(config) {
  config.set({

    // base path, that will be used to resolve files and exclude
    basePath: '',


    // frameworks to use
    frameworks: ['qunit', 'sinon'],


    // list of files / patterns to load in the browser
    files: [
      'vendor/pdfjs/pdf.js',

      'node_modules/three/three.js',
      'node_modules/three/examples/js/renderers/CanvasRenderer.js',
      'node_modules/three/examples/js/renderers/Projector.js',
      'node_modules/three/examples/js/loaders/collada/Animation.js',
      'node_modules/three/examples/js/loaders/collada/AnimationHandler.js',
      'node_modules/three/examples/js/loaders/collada/KeyFrameAnimation.js',
      'node_modules/three/examples/js/MorphAnimMesh.js',
      'node_modules/three/examples/js/loaders/sea3d/SEA3D.js',
      'node_modules/three/examples/js/loaders/sea3d/SEA3DLoader.js',
      'node_modules/three/examples/js/loaders/sea3d/SEA3DLZMA.js',
      'node_modules/three/examples/js/controls/OrbitControls.js',

      'node_modules/jquery/dist/jquery.min.js',
      'node_modules/soyutils/soyutils_nogoog.js',
      'vendor/aui-dist/aui/js/aui-all.js',
      'node_modules/underscore/underscore.js',
      'node_modules/backbone/backbone.js',
      'node_modules/video.js/dist/video-js/video.dev.js',
      'node_modules/videojs-youtube/dist/vjs.youtube.js',
      'build/**/templates/*.i18n.js',
      'support/require.js',
      'lib/!(*.spec).js',
      'lib/**/!(*.spec|*.inject).js',
      'lib/**/*.spec.js',
      'lib/*.spec.js'
    ],


    // list of files to exclude
    exclude: [
    ],


    // test results reporter to use
    // possible values: 'dots', 'progress', 'junit', 'growl', 'coverage'
    reporters: ['progress', 'junit'],

    junitReporter: {
        outputFile: 'test-results-spec.xml'
    },


    // web server port
    port: 9876,


    // enable / disable colors in the output (reporters and logs)
    colors: true,


    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: true,


    // Start these browsers, currently available:
    // - Chrome
    // - ChromeCanary
    // - Firefox
    // - Opera (has to be installed with `npm install karma-opera-launcher`)
    // - Safari (only Mac; has to be installed with `npm install karma-safari-launcher`)
    // - PhantomJS
    // - IE (only Windows; has to be installed with `npm install karma-ie-launcher`)
    browsers: ['Chrome'],


    // If browser does not capture in given timeout [ms], kill it
    captureTimeout: 60000,


    // Continuous Integration mode
    // if true, it capture browsers, run tests and exit
    singleRun: false
  });
};
