!function(FileViewer){"use strict";var define=FileViewer.define;FileViewer.require;define("image-view",["ajs","backbone","underscore","jquery","file","BaseViewer","template-store-singleton"],function(AJS,Backbone,_,$,File,BaseViewer,templateStore){var ImageView=BaseViewer.extend({id:"cp-image-preview",tagName:"div",initialize:function(){BaseViewer.prototype.initialize.apply(this,arguments),this.bindPanEvents(),this.PIXELATE_THRESHOLD=2,this.MIN_HEIGHT=100,this.ZOOM_IN_FACTOR=1.25,this.ZOOM_OUT_FACTOR=.8,this._isFitWidth=!1,this._isFitHeight=!1},renderAnnotations:function(PinsView){var current=this._fileViewer.getCurrentFile(),annotations=current.get("annotations");current&&PinsView&&(this.pinsView=new PinsView({fileViewer:this._fileViewer,container:this.$el.find(".cp-image-container"),collection:annotations}),this.pinsView.render()),annotations.on("selected",function(item){var $pin,positionTop,positionLeft;item&&($pin=this.$el.find("span.cp-active-annotation.selected"),$pin.length&&(positionTop=$pin.position().top-this.$el.height()/2,positionLeft=$pin.position().left-this.$el.width()/2,this.$el.animate({scrollTop:positionTop,scrollLeft:positionLeft})))}.bind(this))},bindPanEvents:function(){var previous={x:0,y:0},view=this,scroll=function(e){var $el=view.$el;$el.scrollLeft($el.scrollLeft()+previous.x-e.clientX),$el.scrollTop($el.scrollTop()+previous.y-e.clientY),previous={x:e.clientX,y:e.clientY},e.preventDefault()},unpan=function(e){view.$el.off("mousemove","#cp-img",scroll),view.$image.removeClass("panning"),e.preventDefault()},pan=function(e){$(window).one("mouseup",unpan),view.$el.on("mousemove","#cp-img",scroll),view.$image.addClass("panning"),previous={x:e.clientX,y:e.clientY},e.preventDefault()};this.$el.on("mousedown","#cp-img",pan)},handleResize:function(){this._forceRescale()},_forceRescale:function(){this._isFitHeight?this.zoomHeight():this._isFitWidth&&this.zoomWidth()},_fixContainerSize:function(){var $container=this.$el.find(".cp-image-container"),$image=this.$el.find("#cp-img");$container.width($image.width()),$container.height($image.height())},_isImageBiggerThanViewport:function(){return this._isImageWiderThanViewport()||this._isImageHigherThanViewport()},_isImageWiderThanViewport:function(){var viewportWidth=this.$el.width();return this.imageWidth>viewportWidth},_isImageHigherThanViewport:function(){var viewportHeight=this.$el.height();return this.imageHeight>viewportHeight},_isZoomedToPageFit:function(){return this.$el.width()===this.$image.width()||this.$el.height()===this.$image.height()},_stopFit:function(){this._isFitWidth=!1,this._isFitHeight=!1},_showScaleInfo:function(scale){if(!this._rescaleForFullScreen){var scalePercentage=Math.round(parseInt(100*scale,10)),$scaleInfo=this.$el.find(".cp-scale-info");$scaleInfo.text(scalePercentage+"%"),$scaleInfo.stop(!0,!0).fadeIn(50).delay(400).fadeOut(100)}},zoomIn:function(){var scaleFactor=this.$image.width()/this.imageWidth*this.ZOOM_IN_FACTOR;this._stopFit(),this.changeScale(scaleFactor)},zoomOut:function(){var scaleFactor=this.$image.width()/this.imageWidth*this.ZOOM_OUT_FACTOR;this._stopFit(),this.changeScale(scaleFactor)},zoomFit:function(){this._isZoomedToPageFit()?this.zoomActual():this.zoomAuto(!0)},zoomAuto:function(force){this._isImageBiggerThanViewport()||force?this._zoomPageFit():this.zoomActual()},_zoomPageFit:function(){var viewportWidth=this.$el.width(),viewportHeight=this.$el.height();viewportWidth/this.imageWidth>viewportHeight/this.imageHeight?this.zoomHeight():this.zoomWidth()},zoomWidth:function(){var viewportWidth=this.$el.width(),scaleFactor=viewportWidth/this.imageWidth;this.changeScale(scaleFactor),this._stopFit(),this._isFitWidth=!0},zoomHeight:function(){var viewportHeight=this.$el.height(),scaleFactor=viewportHeight/this.imageHeight;this.changeScale(scaleFactor),this._stopFit(),this._isFitHeight=!0},zoomActual:function(){this._stopFit(),this.changeScale(1)},changeScale:function(scale){var viewportWidth=this.$el.width(),viewportHeight=this.$el.height(),oldWidth=this.$image.width(),oldHeight=this.$image.height(),containerPosition=this.$el.find(".cp-image-container").position(),oldPixelCentreWidth=viewportWidth/2+Math.abs(containerPosition.left),oldPixelCentreHeight=viewportHeight/2+Math.abs(containerPosition.top);this.$image.css("width",this.imageWidth*scale),this.$image.css("height",this.imageHeight*scale);var newPixelCentreWidth=oldPixelCentreWidth/oldWidth*this.$image.width(),newPixelCentreHeight=oldPixelCentreHeight/oldHeight*this.$image.height();this.$el.scrollLeft(newPixelCentreWidth-viewportWidth/2),this.$el.scrollTop(newPixelCentreHeight-viewportHeight/2),this.makePannable(),this.pixelateIfScaleOverThreshold(scale),this._fixContainerSize(),this._showScaleInfo(scale)},pixelateIfScaleOverThreshold:function(scale){this.$image.toggleClass("pixelate",scale>=this.PIXELATE_THRESHOLD)},makePannable:function(){this.$el.width()<this.$image.width()||this.$el.height()<this.$image.height()?this.$image.addClass("pannable"):this.$image.removeClass("pannable")},teardown:function(){BaseViewer.prototype.teardown.apply(this),$(window).off("resize.cp-repaint"),this.pinsView&&this.pinsView.remove().off()},getBackground:function(){return this.$el.add(".cp-image-container")},render:function(){return this.$el.html(templateStore.get("previewBody")()),this.addImage(),$(window).on("resize.cp-repaint",_.throttle(this._forceRescale.bind(this),250)),this},addImage:function(){var $img=$("<img/>").attr("id","cp-img").attr("src",this._previewSrc).attr("alt",this.model.get("title"));$img.off("load"),$img.on("load",_.partial(this.scaleAndAppendImage,this)),$img.on("load",function(){this.trigger("viewerReady")}.bind(this)),$img.on("error",function(){var err=new Error("Image failed loading");err.title=AJS.I18n.getText("cp.error.image.missing.header"),err.description=this.model.get("src"),err.icon="cp-image-icon",this.trigger("viewerFail",err)}.bind(this)),$img.on("click",function(){document.activeElement.blur()})},scaleAndAppendImage:function(view){var $image=$(this);view.imageHeight=this.height,view.imageWidth=this.width,view.$image=$image,$image.css("display","none");var $imageContainer=view.$el.find(".cp-image-container");$imageContainer.append(view.$image),$imageContainer.addClass("cp-annotatable"),view.zoomAuto(),view.$image.fadeIn(200),view.trigger("cp.imageAppended")},setupMode:function(mode,isModeChanged){isModeChanged&&(clearInterval(this._fullScreenInProgress),this.scaleGraduallyToFit())},scaleGraduallyToFit:function(){var times=0;this._rescaleForFullScreen=!0,this._fullScreenInProgress=setInterval(function(){times++,11===times&&(clearInterval(this._fullScreenInProgress),this._rescaleForFullScreen=!1,this.zoomAuto()),this.zoomAuto()}.bind(this),100)}});return ImageView})}(function(){var FileViewer;return FileViewer="undefined"!=typeof module&&"exports"in module?require("./fileviewer.js"):window.require?window.FileViewer:window.FileViewer}());