!function(FileViewer){"use strict";var define=FileViewer.define;FileViewer.require;define("annotation-layer-builder",["pdf-viewer/viewer-properties","jquery"],function(viewerProperties,$){var AnnotationLayerBuilder=function(opts){this.annotations=opts.annotations,this._fileViewer=opts.fileViewer,this.PinsView=opts.PinsView,this.annotationLayers=[]};return AnnotationLayerBuilder.prototype.create=function(){function AnnotationLayer(options){this.layerDiv=options.layerDiv,this.pageIdx=options.pageIndex,this.lastScrollSource=options.lastScrollSource||null,this.viewport=options.viewport,this.isViewerInPresentationMode=options.isViewerInPresentationMode,this.renderTimer=null,that.annotationLayers.push(this),this.pinsView=new that.PinsView({fileViewer:that._fileViewer,container:$(this.layerDiv),filter:function(annotation){return annotation.get("pageNumber")===this.pageIdx+1}.bind(this),collection:that.annotations}),this.layerDiv.className="annotationLayer"}var that=this;return AnnotationLayer.prototype={render:function(){this.pinsView.render()},setupRenderLayoutTimer:function(){var self=this,lastScroll=null===this.lastScrollSource?0:this.lastScrollSource.lastScroll;Date.now()-lastScroll>viewerProperties.RENDER_DELAY?this.render():(this.renderTimer&&clearTimeout(this.renderTimer),this.renderTimer=setTimeout(function(){self.setupRenderLayoutTimer()},viewerProperties.RENDER_DELAY))}},AnnotationLayer},AnnotationLayerBuilder.prototype.updateAnnotations=function(annotations){this.annotations=annotations,this.annotationLayers.forEach(function(layer){layer.render()})},AnnotationLayerBuilder}),define("pdf-viewer/cache",["pdf-viewer/viewer-properties"],function(viewerProperties){var Cache=function(size){var data=[];this.push=function(view){var i=data.indexOf(view);i>=0&&data.splice(i,1),data.push(view),data.length>size&&data.shift().destroy()},this.resize=function(newSize){for(size=newSize;data.length>size;)data.shift().destroy()}};return new Cache(viewerProperties.DEFAULT_CACHE_SIZE)}),define("pdf-viewer/page-view-scroll",[],function(){return{}}),define("pdf-viewer/utils",[],function(){var approximateFraction=function(x){if(Math.floor(x)===x)return[x,1];var xinv=1/x,limit=8;if(xinv>limit)return[1,limit];if(Math.floor(xinv)===xinv)return[1,xinv];for(var x_=x>1?xinv:x,a=0,b=1,c=1,d=1;;){var p=a+c,q=b+d;if(q>limit)break;p/q>=x_?(c=p,d=q):(a=p,b=q)}return c/d-x_>x_-a/b?x_===x?[a,b]:[b,a]:x_===x?[c,d]:[d,c]},roundToDivide=function(x,div){var r=x%div;return 0===r?x:Math.round(x-r+div)},getOutputScale=function(ctx){var devicePixelRatio=window.devicePixelRatio||1,backingStoreRatio=ctx.webkitBackingStorePixelRatio||ctx.mozBackingStorePixelRatio||ctx.msBackingStorePixelRatio||ctx.oBackingStorePixelRatio||ctx.backingStorePixelRatio||1,pixelRatio=devicePixelRatio/backingStoreRatio;return{sx:pixelRatio,sy:pixelRatio,scaled:1!=pixelRatio}};return{approximateFraction:approximateFraction,roundToDivide:roundToDivide,getOutputScale:getOutputScale}}),define("pdf-viewer/page-view",["pdf-viewer/utils","pdf-viewer/viewer-properties","pdf-viewer/rendering-states","pdf-viewer/presentation-mode","pdf-viewer/text-layer-builder","pdf-viewer/cache"],function(viewerUtils,viewerProperties,renderingStates,PresentationMode,TextLayerBuilder,cache){function scrollIntoView(element,containerEl,spot){var parent=containerEl,offsetY=element.offsetTop+element.clientTop,offsetX=element.offsetLeft+element.clientLeft;if(!parent)return void console.error("container element is not set -- cannot scroll");for(;parent.clientHeight===parent.scrollHeight;)if(parent.dataset._scaleY&&(offsetY/=parent.dataset._scaleY,offsetX/=parent.dataset._scaleX),offsetY+=parent.offsetTop,offsetX+=parent.offsetLeft,parent=parent.offsetParent,!parent)return;spot&&(void 0!==spot.top&&(offsetY+=spot.top),void 0!==spot.left&&(offsetX+=spot.left,parent.scrollLeft=offsetX)),parent.scrollTop=offsetY}var PDFJS=window.PDFJS,CustomStyle=PDFJS.CustomStyle,PageView=function(container,id,scale,defaultViewport,parentViewer){this.id=id,this.parentViewer=parentViewer,this.rotation=0,this.scale=scale||1,this.viewport=defaultViewport,this.pdfPageRotate=defaultViewport.rotation,this.renderingState=renderingStates.INITIAL,this.resume=null,this.textLayer=null,this.layers=[],this.zoomLayer=null,this.annotationLayer=null,this.linkLayer=null;var anchor=document.createElement("a");anchor.name=""+this.id;var div=this.el=document.createElement("div");div.id="pageContainer"+this.id,div.setAttribute("data-page-number",this.id),div.className="page",div.style.width=Math.floor(this.viewport.width)+"px",div.style.height=Math.floor(this.viewport.height)+"px",container.appendChild(anchor),container.appendChild(div),this.setPdfPage=function(pdfPage){this.pdfPage=pdfPage,this.pdfPageRotate=pdfPage.rotate;var totalRotation=(this.rotation+this.pdfPageRotate)%360;this.viewport=pdfPage.getViewport(this.scale*viewerProperties.CSS_UNITS,totalRotation),this.stats=pdfPage.stats,this.reset()},this.destroy=function(){this.zoomLayer=null,this.reset(),this.pdfPage&&this.pdfPage.destroy()},this.reset=function(keepAnnotations,keepLinks){this.renderTask&&this.renderTask.cancel(),this.resume=null,this.renderingState=renderingStates.INITIAL,div.style.width=Math.floor(this.viewport.width)+"px",div.style.height=Math.floor(this.viewport.height)+"px";for(var childNodes=div.childNodes,i=div.childNodes.length-1;i>=0;i--){var node=childNodes[i];this.zoomLayer&&this.zoomLayer===node||keepAnnotations&&this.annotationLayer===node||keepLinks&&this.linkLayer===node||div.removeChild(node)}div.removeAttribute("data-loaded"),keepAnnotations?this.annotationLayer&&this.annotationLayer.setAttribute("hidden","true"):this.annotationLayer=null,keepLinks||(this.linkLayer=null),delete this.canvas,this.loadingIconDiv=document.createElement("div"),this.loadingIconDiv.className="loadingIcon",div.appendChild(this.loadingIconDiv)},this.update=function(scale,rotation){this.scale=scale||this.scale,"undefined"!=typeof rotation&&(this.rotation=rotation);var totalRotation=(this.rotation+this.pdfPageRotate)%360;return this.viewport=this.viewport.clone({scale:this.scale*viewerProperties.CSS_UNITS,rotation:totalRotation}),viewerProperties.USE_ONLY_CSS_ZOOM&&this.canvas?void this.cssTransform(this.canvas):(this.canvas&&!this.zoomLayer&&(this.zoomLayer=this.canvas.parentNode,this.zoomLayer.style.position="absolute"),this.zoomLayer&&this.cssTransform(this.zoomLayer.firstChild),void this.reset(!0,!0))},this.cssTransform=function(canvas){var width=this.viewport.width,height=this.viewport.height;canvas.style.width=canvas.parentNode.style.width=div.style.width=Math.floor(width)+"px",canvas.style.height=canvas.parentNode.style.height=div.style.height=Math.floor(height)+"px";var relativeRotation=this.viewport.rotation-canvas._viewport.rotation,absRotation=Math.abs(relativeRotation),scaleX=1,scaleY=1;90!==absRotation&&270!==absRotation||(scaleX=height/width,scaleY=width/height);var cssTransform="rotate("+relativeRotation+"deg) scale("+scaleX+","+scaleY+")";if(CustomStyle.setProp("transform",canvas,cssTransform),this.textLayer){var textRelativeRotation=this.viewport.rotation-this.textLayer.viewport.rotation,textAbsRotation=Math.abs(textRelativeRotation),scale=width/canvas.width;90!==textAbsRotation&&270!==textAbsRotation||(scale=width/canvas.height);var transX,transY,textLayerDiv=this.textLayer.textLayerDiv;switch(textAbsRotation){case 0:transX=transY=0;break;case 90:transX=0,transY="-"+textLayerDiv.style.height;break;case 180:transX="-"+textLayerDiv.style.width,transY="-"+textLayerDiv.style.height;break;case 270:transX="-"+textLayerDiv.style.width,transY=0;break;default:console.error("Bad rotation value.")}CustomStyle.setProp("transform",textLayerDiv,"rotate("+textAbsRotation+"deg) scale("+scale+", "+scale+") translate("+transX+", "+transY+")"),CustomStyle.setProp("transformOrigin",textLayerDiv,"0% 0%")}setupInternalLinks(div,this.pdfPage,this.viewport)},Object.defineProperty(this,"width",{get:function(){return this.viewport.width},enumerable:!0}),Object.defineProperty(this,"height",{get:function(){return this.viewport.height},enumerable:!0}),this.getPagePoint=function(x,y){return this.viewport.convertToPdfPoint(x,y)},this.scrollIntoView=function(dest){if(PresentationMode.active&&(this.parentViewer.page!==this.id&&(this.parentViewer.page=this.id),dest=null,this.parentViewer.setScale(this.parentViewer.currentScaleValue,!0,!0)),!dest)return void scrollIntoView(div,this.parentViewer.el.container);var widthScale,heightScale,x=0,y=0,width=0,height=0,changeOrientation=this.rotation%180!==0,pageWidth=(changeOrientation?this.height:this.width)/this.scale/viewerProperties.CSS_UNITS,pageHeight=(changeOrientation?this.width:this.height)/this.scale/viewerProperties.CSS_UNITS,scale=0;switch(dest[1]||(dest[1]=""),dest[1].name){case"XYZ":x=dest[2],y=dest[3],scale=dest[4],x=null!==x?x:0,y=null!==y?y:pageHeight;break;case"Fit":case"FitB":scale="page-fit";break;case"FitH":case"FitBH":y=dest[2],scale="page-width";break;case"FitV":case"FitBV":x=dest[2],width=pageWidth,height=pageHeight,scale="page-height";break;case"FitR":x=dest[2],y=dest[3],width=dest[4]-x,height=dest[5]-y,widthScale=(this.parentViewer.viewer.clientWidth-viewerProperties.VERTICAL_PADDING)/width/viewerProperties.CSS_UNITS,heightScale=(this.parentViewer.viewer.clientHeight-viewerProperties.VERTICAL_PADDING)/height/viewerProperties.CSS_UNITS,scale=Math.min(Math.abs(widthScale),Math.abs(heightScale));break;default:return}if(scale&&scale!==this.parentViewer.currentScale?this.parentViewer.setScale(scale,!0,!0):this.parentViewer.currentScale===viewerProperties.UNKNOWN_SCALE&&this.parentViewer.setScale(viewerProperties.DEFAULT_SCALE,!0,!0),"page-fit"===scale&&!dest[4])return void scrollIntoView(div,this.parentViewer.el.container);var boundingRect=[this.viewport.convertToViewportPoint(x,y),this.viewport.convertToViewportPoint(x+width,y+height)],left=Math.min(boundingRect[0][0],boundingRect[1][0]),top=Math.min(boundingRect[0][1],boundingRect[1][1]);scrollIntoView(div,this.parentViewer.el.container,{left:left,top:top})},this.getTextContent=function(){return this.parentViewer.getPage(this.id).then(function(pdfPage){return pdfPage.getTextContent()})},this.draw=function(callback){function pageViewDrawCallback(error){if(renderTask===self.renderTask&&(self.renderTask=null),"cancelled"!==error){self.renderingState=renderingStates.FINISHED,isCanvasHidden&&(self.canvas.removeAttribute("hidden"),isCanvasHidden=!1),self.loadingIconDiv&&(div.removeChild(self.loadingIconDiv),delete self.loadingIconDiv),self.zoomLayer&&(div.removeChild(self.zoomLayer),self.zoomLayer=null),self.onAfterDraw&&self.onAfterDraw(),cache.push(self);var event=document.createEvent("CustomEvent");event.initCustomEvent("pagerender",!0,!0,{pageNumber:pdfPage.pageNumber}),div.dispatchEvent(event),callback()}}var pdfPage=this.pdfPage,beforeLayer=this.annotationLayer||this.linkLayer||null;if(!this.pagePdfPromise){if(!pdfPage){var promise=this.parentViewer.getPage(this.id);return promise.then(function(pdfPage){delete this.pagePdfPromise,this.setPdfPage(pdfPage),this.draw(callback)}.bind(this)),void(this.pagePdfPromise=promise)}this.renderingState!==renderingStates.INITIAL&&console.error("Must be in new state before drawing"),this.renderingState=renderingStates.RUNNING;var viewport=this.viewport,canvasWrapper=document.createElement("div");canvasWrapper.style.width=div.style.width,canvasWrapper.style.height=div.style.height,canvasWrapper.classList.add("canvasWrapper");var canvas=document.createElement("canvas");canvas.id="page"+this.id,canvas.setAttribute("hidden","hidden");var isCanvasHidden=!0;canvasWrapper.appendChild(canvas),div.insertBefore(canvasWrapper,beforeLayer),this.canvas=canvas,canvas.mozOpaque=!0;var ctx=canvas.getContext("2d",{alpha:!1}),outputScale=viewerUtils.getOutputScale(ctx);if(viewerProperties.USE_ONLY_CSS_ZOOM){var actualSizeViewport=viewport.clone({scale:viewerProperties.CSS_UNITS});outputScale.sx*=actualSizeViewport.width/viewport.width,outputScale.sy*=actualSizeViewport.height/viewport.height,outputScale.scaled=!0}var sfx=viewerUtils.approximateFraction(outputScale.sx),sfy=viewerUtils.approximateFraction(outputScale.sy);canvas.width=viewerUtils.roundToDivide(viewport.width*outputScale.sx,sfx[0]),canvas.height=viewerUtils.roundToDivide(viewport.height*outputScale.sy,sfy[0]),canvas.style.width=viewerUtils.roundToDivide(viewport.width,sfx[1])+"px",canvas.style.height=viewerUtils.roundToDivide(viewport.height,sfy[1])+"px",canvas._viewport=viewport;var textLayerDiv=null;PDFJS.disableTextLayer||(textLayerDiv=document.createElement("div"),textLayerDiv.className="textLayer",textLayerDiv.style.width=canvas.style.width,textLayerDiv.style.height=canvas.style.height,div.insertBefore(textLayerDiv,beforeLayer));var textLayer=this.textLayer=textLayerDiv?new TextLayerBuilder({textLayerDiv:textLayerDiv,pageIndex:this.id-1,lastScrollSource:parentViewer,viewport:this.viewport,isViewerInPresentationMode:PresentationMode.active}):null;if(!this.linkLayer){var linkLayerDiv=document.createElement("div");linkLayerDiv.className="linkLayer",div.appendChild(linkLayerDiv),this.linkLayer=linkLayerDiv}if(parentViewer.layerBuilders&&!PresentationMode.active)for(var i=0;i<parentViewer.layerBuilders.length;i++){var layerDiv=document.createElement("div");layerDiv.style.width=canvas.style.width,layerDiv.style.height=canvas.style.height;var LayerBuilder=parentViewer.layerBuilders[i],layer=new LayerBuilder({layerDiv:layerDiv,pageIndex:this.id-1,lastScrollSource:parentViewer,viewport:this.viewport,isViewerInPresentationMode:PresentationMode.active});this.layers.push(layer),div.appendChild(layerDiv),layer.setupRenderLayoutTimer&&layer.setupRenderLayoutTimer()}var self=this,transform=outputScale.scaled?[outputScale.sx,0,0,outputScale.sy,0,0]:null,renderContext={canvasContext:ctx,transform:transform,viewport:this.viewport,textLayer:textLayer,continueCallback:function(cont){return self.parentViewer.highestPriorityPage!=="page"+self.id?(self.renderingState=renderingStates.PAUSED,void(self.resume=function(){self.renderingState=renderingStates.RUNNING,cont()})):(isCanvasHidden&&(self.canvas.removeAttribute("hidden"),isCanvasHidden=!1),void cont())}},renderTask=this.renderTask=this.pdfPage.render(renderContext);this.renderTask.promise.then(function(){pageViewDrawCallback(null),textLayer&&self.getTextContent().then(function(textContent){textLayer.setTextContent(textContent)})},function(error){pageViewDrawCallback(error)}),setupInternalLinks(div,pdfPage,this.viewport),div.setAttribute("data-loaded",!0)}};var setupInternalLinks=function(pageDiv,pdfPage,viewport){var self=this,pdfViewer=self.parentViewer;pdfPage.getAnnotations().then(function(annotationsData){var PDFJS=window.PDFJS;if(viewport=viewport.clone({dontFlip:!0}),self.linkLayer&&self.linkLayer.childElementCount>0)PDFJS.AnnotationLayer.update({viewport:viewport,div:self.linkLayer,page:pdfPage,annotations:annotationsData,linkService:pdfViewer.linkService});else{if(0===annotationsData.length)return;self.linkLayer||(self.linkLayer=document.createElement("div"),self.linkLayer.className="linkLayer",pageDiv.appendChild(self.linkLayer)),self.linkLayer.innerHTML="",PDFJS.AnnotationLayer.render({viewport:viewport,div:self.linkLayer,page:pdfPage,annotations:annotationsData,linkService:pdfViewer.linkService})}})}.bind(this)};return PageView}),define("pdf-viewer/pdf-link-service",["url"],function(urlHelper){function PDFLinkService(){this.baseUrl=null,this.pdfDocument=null,this.pdfViewer=null,this.pdfHistory=null,this._pagesRefCache=null}return PDFLinkService.prototype={setDocument:function(pdfDocument,baseUrl){this.baseUrl=baseUrl,this.pdfDocument=pdfDocument,this._pagesRefCache=Object.create(null)},setViewer:function(pdfViewer){this.pdfViewer=pdfViewer},setHistory:function(pdfHistory){this.pdfHistory=pdfHistory},get pagesCount(){return this.pdfDocument.numPages},get page(){return this.pdfViewer.currentPageNumber},set page(value){this.pdfViewer.currentPageNumber=value},navigateTo:function(dest){var destinationPromise,destString="",self=this,goToDestination=function(destRef){var pageNumber=destRef instanceof Object?self._pagesRefCache[destRef.num+" "+destRef.gen+" R"]:destRef+1;pageNumber?(pageNumber>self.pagesCount&&(pageNumber=self.pagesCount),self.pdfViewer.scrollPageIntoView(pageNumber,dest),self.pdfHistory&&self.pdfHistory.push({dest:dest,hash:destString,page:pageNumber})):self.pdfDocument.getPageIndex(destRef).then(function(pageIndex){var pageNum=pageIndex+1,cacheKey=destRef.num+" "+destRef.gen+" R";self._pagesRefCache[cacheKey]=pageNum,goToDestination(destRef)})};"string"==typeof dest?(destString=dest,destinationPromise=this.pdfDocument.getDestination(dest)):destinationPromise=Promise.resolve(dest),destinationPromise.then(function(destination){dest=destination,destination instanceof Array&&goToDestination(destination[0])})},getDestinationHash:function(dest){if("string"==typeof dest)return this.getAnchorUrl("#"+escape(dest));if(dest instanceof Array){var destRef=dest[0],pageNumber=destRef instanceof Object?this._pagesRefCache[destRef.num+" "+destRef.gen+" R"]:destRef+1;if(pageNumber){var pdfOpenParams=this.getAnchorUrl("#page="+pageNumber),destKind=dest[1];if("object"==typeof destKind&&"name"in destKind&&"XYZ"===destKind.name){var scale=dest[4]||this.pdfViewer.currentScaleValue,scaleNumber=parseFloat(scale);scaleNumber&&(scale=100*scaleNumber),pdfOpenParams+="&zoom="+scale,(dest[2]||dest[3])&&(pdfOpenParams+=","+(dest[2]||0)+","+(dest[3]||0))}return pdfOpenParams}}return this.getAnchorUrl("")},getAnchorUrl:function(anchor){return(this.baseUrl||"")+anchor},setHash:function(hash){if(hash.indexOf("=")>=0){var params=urlHelper.parseQueryString(hash);if("nameddest"in params)return this.pdfHistory&&this.pdfHistory.updateNextHashParam(params.nameddest),void this.navigateTo(params.nameddest);var pageNumber,dest;if("page"in params&&(pageNumber=0|params.page||1),"zoom"in params){var zoomArgs=params.zoom.split(","),zoomArg=zoomArgs[0],zoomArgNumber=parseFloat(zoomArg);-1===zoomArg.indexOf("Fit")?dest=[null,{name:"XYZ"},zoomArgs.length>1?0|zoomArgs[1]:null,zoomArgs.length>2?0|zoomArgs[2]:null,zoomArgNumber?zoomArgNumber/100:zoomArg]:"Fit"===zoomArg||"FitB"===zoomArg?dest=[null,{name:zoomArg}]:"FitH"===zoomArg||"FitBH"===zoomArg||"FitV"===zoomArg||"FitBV"===zoomArg?dest=[null,{name:zoomArg},zoomArgs.length>1?0|zoomArgs[1]:null]:"FitR"===zoomArg?5!==zoomArgs.length?console.error("PDFLinkService_setHash: Not enough parameters for 'FitR'."):dest=[null,{name:zoomArg},0|zoomArgs[1],0|zoomArgs[2],0|zoomArgs[3],0|zoomArgs[4]]:console.error("PDFLinkService_setHash: '"+zoomArg+"' is not a valid zoom value.")}if(dest?this.pdfViewer.scrollPageIntoView(pageNumber||this.page,dest):pageNumber&&(this.page=pageNumber),"pagemode"in params){var event=document.createEvent("CustomEvent");event.initCustomEvent("pagemode",!0,!0,{mode:params.pagemode}),this.pdfViewer.container.dispatchEvent(event)}}else/^\d+$/.test(hash)?this.page=hash:(this.pdfHistory&&this.pdfHistory.updateNextHashParam(unescape(hash)),this.navigateTo(unescape(hash)))},executeNamedAction:function(action){switch(action){case"GoBack":this.pdfHistory&&this.pdfHistory.back();break;case"GoForward":this.pdfHistory&&this.pdfHistory.forward();break;case"NextPage":this.page++;break;case"PrevPage":this.page--;break;case"LastPage":this.page=this.pagesCount;break;case"FirstPage":this.page=1}var event=document.createEvent("CustomEvent");event.initCustomEvent("namedaction",!0,!0,{action:action}),this.pdfViewer.container.dispatchEvent(event)},cachePageRef:function(pageNum,pageRef){var refStr=pageRef.num+" "+pageRef.gen+" R";this._pagesRefCache[refStr]=pageNum}},PDFLinkService}),define("pdf-view",["ajs","backbone","jquery","pdf-viewer/viewer-properties","pdf-viewer/pdf-viewer","pdf-viewer/page-view-scroll","pdf-viewer/presentation-mode","pdf-viewer/pdf-link-service","annotation-layer-builder","BaseViewer","template-store-singleton"],function(AJS,Backbone,$,viewerProperties,PDFViewer,pageViewScroll,PresentationMode,PDFLinkService,AnnotationLayerBuilder,BaseViewer,templateStore){var PDFJS=window.PDFJS;PDFJS.externalLinkTarget=PDFJS.LinkTarget.BLANK;var when=function(val){return val&&val.then?val:(new $.Deferred).resolve(val).promise()},SCALE={PAGE_WIDTH:"page-width",PAGE_HEIGHT:"page-height",PAGE_FIT:"page-fit",AUTO:"auto",PAGE_ACTUAL:"page-actual",CUSTOM:"custom"},createPdfError=function(pdfjsErr,model){var err=new Error(pdfjsErr.toString()),reason=pdfjsErr.message.split(":")[0];switch(reason){case"PasswordException":err.title=AJS.I18n.getText("cp.error.pdf.password.header"),err.description=AJS.I18n.getText("cp.error.pdf.password.message"),err.download=!0;break;case"InvalidPDFException":err.title=AJS.I18n.getText("cp.error.pdf.invalid.header"),err.description=AJS.I18n.getText("cp.error.pdf.invalid.message"),err.download=!0;break;case"MissingPDFException":case"UnexpectedResponseException":err.title=AJS.I18n.getText("cp.error.pdf.missing.header"),err.description=model.get("src");break;case"UnknownErrorException":default:err.title=AJS.I18n.getText("cp.error.pdf.default.header"),err.description=model.get("src")}return err.icon="cp-pdf-icon",err},PDFView=BaseViewer.extend({id:"cp-pdf-preview",tagName:"div",initialize:function(){BaseViewer.prototype.initialize.apply(this,arguments);var linkService=this.linkService=new PDFLinkService,viewer=this.viewer=new PDFViewer({container:document.getElementById("cp-pdf-preview"),viewer:document.getElementById("viewer"),linkService:linkService});linkService.setViewer(this.viewer),this.fileBody=document.getElementById("cp-file-body"),this.scaleChangeListener=function(evt){viewer.updateViewarea(),this._fileViewer.getView().updatePaginationButtons()}.bind(this),$(window).on("scalechange.pdfPreviewView",this.scaleChangeListener),viewer.watchScroll(this.el,pageViewScroll,viewer.updateViewarea)},teardown:function(){BaseViewer.prototype.teardown.apply(this),$(window).off("scalechange.pdfPreviewView",this.scaleChangeListener),this._enableScroll(),this.viewer.watchScrollEnd(this.fileBody),this.stopListening(),this.viewer.close()},getBackground:function(){return this.$el.add("#viewer")},scrollCenter:function(){var $container=$(this.viewer.el.container),containerWidth=$container.width(),$currentPage=$(this.viewer.pages[this.viewer.page].el),currentPageWidth=$currentPage.width();if(!(containerWidth>currentPageWidth)){var offsetLeft=(currentPageWidth-containerWidth)/2;$container.scrollLeft(offsetLeft)}},zoomFit:function(){this.viewer.currentScaleValue===SCALE.PAGE_WIDTH?(this.viewer.setScale(this.viewer.recentScaleValue),this.viewer.currentScaleValue=this.viewer.recentScaleValue):(this.viewer.recentScaleValue=this.viewer.currentScaleValue,this.viewer.setScale(SCALE.PAGE_WIDTH),this.viewer.currentScaleValue=SCALE.PAGE_WIDTH)},zoomIn:function(){this.viewer.zoomIn(),this.scrollCenter()},zoomOut:function(){this.viewer.zoomOut(),this.scrollCenter()},render:function(){return this.$el.html(templateStore.get("PDFViewer.preview")()),this.viewer.setContainer({container:this.el,viewer:this.$el.find("#viewer")[0],outerContainer:this.$el.find("#outerContainer")[0]}),this._openViewer(this._fileViewer.getConfig().pdfTransportFactory),this},renderAnnotations:function(PinsView){var annotations=this.model.get("annotations"),layerBuilder=new AnnotationLayerBuilder({annotations:annotations,fileViewer:this._fileViewer,PinsView:PinsView});this.viewer.addLayerBuilder(layerBuilder.create());var that=this;this.listenTo(annotations,"add remove reset sync",function(){layerBuilder.updateAnnotations(annotations)}),this.listenTo(annotations,"selected",function(item){if(item){var pageNumber=item.attributes.pageNumber;pageNumber>that.viewer.pages.length&&(pageNumber=that.viewer.pages.length),that.viewer.pages&&that.viewer.pages[pageNumber-1]&&that.viewer.pages[pageNumber-1].scrollIntoView([null,{name:"Fit"}])}})},_openViewer:function(pdfTransportFactory){if(!window.ArrayBuffer){var err=new Error;return err.title=AJS.I18n.getText("cp.unsupported.browser.header"),err.description=AJS.I18n.getText("cp.unsupported.browser.download.to.view"),err.icon="cp-pdf-icon",void this.trigger("viewerFail",err)}var createPdfTransportPromise=function(){return when(pdfTransportFactory&&pdfTransportFactory(this._fileViewer.getCurrentFile()))}.bind(this),viewerFailed=function(oldErr){var err=createPdfError(oldErr,this.model);this.trigger("viewerFail",err)}.bind(this),viewerSucceeded=function(pdfTransport){var defaultScale=viewerProperties[PresentationMode.active?"DEFAULT_SCALE_PRESENTATION":"DEFAULT_SCALE"],passwordLayer=this._fileViewer._view.fileContentView.getLayerForName("password");this.viewer.openFile(this._previewSrc,defaultScale,void 0,passwordLayer,pdfTransport).then(function(){this.trigger("viewerReady")}.bind(this),viewerFailed)}.bind(this);createPdfTransportPromise().done(viewerSucceeded).fail(viewerFailed)},goToPreviousPage:function(){this.viewer.goToPreviousPage()},goToNextPage:function(){this.viewer.goToNextPage()},hasPreviousPage:function(){return this.viewer.page>1},hasNextPage:function(){return this.viewer.page<this.viewer.pages.length},_preventDefault:function(e){e=e||window.event,e.preventDefault&&e.preventDefault(),e.returnValue=!1},_disableScroll:function(){window.addEventListener("DOMMouseScroll",this._preventDefault,!1),window.onmousewheel=document.onmousewheel=this._preventDefault,$("#cp-pdf-preview").addClass("hide-scrollbar")},_enableScroll:function(){window.removeEventListener("DOMMouseScroll",this._preventDefault,!1),window.onmousewheel=document.onmousewheel=null,$("#cp-pdf-preview").removeClass("hide-scrollbar")},_setPagePadding:function(){var pagePadding;if(PresentationMode.active)pagePadding={x:0,y:0};else{pagePadding={x:viewerProperties.SCROLLBAR_PADDING,y:viewerProperties.VERTICAL_PADDING};var arrowLayer=this._fileViewer.getView().fileContentView.getLayerForName("arrows");arrowLayer.showsArrow()&&(pagePadding.x=viewerProperties.NAVIGATION_ARROW_PADDING)}this.viewer.setPagePadding(pagePadding)},setupMode:function(mode,isModeChanged){"PRESENTATION"===mode?(PresentationMode.active=!0,this._disableScroll()):(PresentationMode.active=!1,this._enableScroll()),this._setPagePadding(),isModeChanged&&this._scaleGraduallyToFitPage()},_scaleGraduallyToFitPage:function(){var times=0,fullScreenInProgress=setInterval(function(){times++,11===times&&(clearInterval(fullScreenInProgress),this.viewer.goToPage(this.viewer.page)),this._scaleToFitPage()}.bind(this),100)},_scaleToFitPage:function(){this.viewer.setScale(SCALE.PAGE_FIT,!0),this.viewer.currentScaleValue=SCALE.PAGE_FIT},annotationOptions:{dropTarget:"#viewer .page .annotationLayer",annotationCreated:function(elem){var $elem=$(elem);return{pageNumber:parseInt($elem.closest(".page").attr("data-page-number"),10)}}}});return PDFView}),define("pdf-viewer/pdf-viewer",["underscore","jquery","ajs","pdf-viewer/viewer-properties","pdf-viewer/page-view","pdf-viewer/rendering-states","pdf-viewer/presentation-mode","pdf-viewer/cache","pdf-viewer/page-view-scroll"],function(_,$,AJS,viewerProperties,PageView,renderingStates,PresentationMode,cache,pageViewScroll){function PDFViewer(options){PDFJS.UnsupportedManager.listen(_.bind(PDFViewer.prototype.fallback,PDFViewer)),PDFJS.verbosity=PDFJS.VERBOSITY_LEVELS.errors,PDFJS.cMapPacked=!0,PDFJS.disableAutoFetch=!0,this.lastScroll=0,this.layerBuilders=[],this.pages=[],this._pagePadding={x:viewerProperties.SCROLLBAR_PADDING,y:viewerProperties.VERTICAL_PADDING},this.linkService=options.linkService}var PDFJS=window.PDFJS;return PDFViewer.prototype.watchScroll=function(viewAreaElement,state,callback){state.down=!0,state.lastY=viewAreaElement.scrollTop;var viewer=this;$(viewAreaElement).on("scroll.pdfViewer",function(evt){viewer.lastScroll=Date.now();var currentY=viewAreaElement.scrollTop,lastY=state.lastY;currentY>lastY?state.down=!0:lastY>currentY&&(state.down=!1),state.lastY=currentY,callback.call(viewer)})},PDFViewer.prototype.watchScrollEnd=function(viewAreaElement){$(viewAreaElement).off("scroll.pdfViewer")},PDFViewer.prototype.setContainer=function(args){this.el={container:args.container,viewer:args.viewer,outerContainer:args.outerContainer}},PDFViewer.prototype.addLayerBuilder=function(layerBuilder){layerBuilder&&this.layerBuilders.push(layerBuilder)},PDFViewer.prototype._setScaleUpdatePages=function(newScale,newValue,resetAutoSettings,noScroll){if(this.currentScaleValue=newValue,newScale!==this.currentScale){for(var i=0,ii=this.pages.length;ii>i;i++)this.pages[i].update(newScale);if(this.currentScale=newScale,!noScroll){var dest,page=this.page;this.currentPosition&&!viewerProperties.IGNORE_CURRENT_POSITION_ON_ZOOM&&(page=this.currentPosition.page,dest=[null,{name:"XYZ"},this.currentPosition.left,this.currentPosition.top,null]),this.pages[page-1].scrollIntoView(dest)}var event=document.createEvent("UIEvents");event.initUIEvent("scalechange",!1,!1,window,0),event.scale=newScale,event.resetAutoSettings=resetAutoSettings,window.dispatchEvent(event)}},PDFViewer.prototype.setPagePadding=function(padding){this._pagePadding={x:parseInt(padding.x,10)||0,y:parseInt(padding.y,10)||0}},PDFViewer.prototype.setScale=function(value,resetAutoSettings,noScroll){if("custom"!==value){var scale=parseFloat(value);if(scale>0)this._setScaleUpdatePages(scale,value,!0,noScroll);else{var currentPage=this.pages[this.page-1];if(!currentPage)return;var hPadding=this._pagePadding.x,vPadding=this._pagePadding.y,pageWidthScale=(this.el.container.clientWidth-hPadding)/currentPage.width*currentPage.scale,pageHeightScale=(this.el.container.clientHeight-vPadding)/currentPage.height*currentPage.scale;switch(value){case"page-actual":scale=1;break;case"page-width":scale=pageWidthScale;break;case"page-height":scale=pageHeightScale;break;case"page-fit":scale=Math.min(pageWidthScale,pageHeightScale),value=scale===pageWidthScale?"page-width":"page-height";break;case"auto":scale=Math.min(viewerProperties.MAX_AUTO_SCALE,pageWidthScale);break;default:return void console.error("pdfViewSetScale: '"+value+"' is an unknown zoom value.")}this._setScaleUpdatePages(scale,value,resetAutoSettings,noScroll)}}},PDFViewer.prototype.zoomIn=function(ticks){var newScale=this.currentScale;do newScale=(newScale*viewerProperties.DEFAULT_SCALE_DELTA).toFixed(2),newScale=Math.ceil(10*newScale)/10,newScale=Math.min(viewerProperties.MAX_SCALE,newScale);while(--ticks&&newScale<viewerProperties.MAX_SCALE);this.setScale(newScale,!0)},PDFViewer.prototype.zoomOut=function(ticks){var newScale=this.currentScale;do newScale=(newScale/viewerProperties.DEFAULT_SCALE_DELTA).toFixed(2),newScale=Math.floor(10*newScale)/10,newScale=Math.max(viewerProperties.MIN_SCALE,newScale);while(--ticks&&newScale>viewerProperties.MIN_SCALE);this.setScale(newScale,!0)},PDFViewer.prototype.openFile=function(url,scale,password,passwordLayer,pdfDataRangeTransport,args){var parameters={};if("string"==typeof url?parameters.url=url:url&&"byteLength"in url&&(parameters.data=url),args)for(var prop in args)parameters[prop]=args[prop];var self=this;return self.loading=!0,self.downloadComplete=!1,self._pdfLoadingTask=PDFJS.getDocument(parameters,pdfDataRangeTransport),self._pdfLoadingTask.onProgress=function(progressData){self.progress(progressData.loaded/progressData.total)},self._pdfLoadingTask.onPassword=function(updatePassword,reason){passwordLayer.showPasswordInput(reason,updatePassword)},self._pdfLoadingTask.promise.then(function(pdfDocument){var loadedPromise=self.load(pdfDocument,scale);return self.loading=!1,loadedPromise},function(message,exception){return self.loading=!1,new Promise(function(resolve,reject){reject(exception||new Error(message))})})},PDFViewer.prototype.close=function(){this._pdfLoadingTask&&(this._pdfLoadingTask.then(function(){this.cleanup(),this.pdfDocument.destroy(),this.pdfDocument=null,clearTimeout(this.idleTimeout);for(var i=0;i<this.pages.length;i++)this.pages[i].destroy();this.pages=[];for(var container=this.el.viewer;container.hasChildNodes();)container.removeChild(container.lastChild);
}.bind(this),function(error){if("MissingPDFException"!==error.name)throw error}),this._pdfLoadingTask.destroy(),this.pdfLoadingTask=null)},PDFViewer.prototype.load=function(pdfDocument,scale){function bindOnAfterDraw(pageView){pageView.onAfterDraw=function(){isOnePageRenderedResolved||(isOnePageRenderedResolved=!0,resolveOnePageRendered())}}var self=this,isOnePageRenderedResolved=!1,resolveOnePageRendered=null,onePageRendered=new Promise(function(resolve){resolveOnePageRendered=resolve});this.pdfDocument=pdfDocument;var baseDocumentUrl=null;this.linkService.setDocument(pdfDocument,baseDocumentUrl);var downloadedPromise=pdfDocument.getDownloadInfo().then(function(){self.downloadComplete=!0;var outerContainer=self.el.outerContainer;outerContainer.classList.remove("loadingInProgress")}),pagesCount=pdfDocument.numPages,pages=this.pages=[];self.pagesRefMap={};var firstPagePromise=pdfDocument.getPage(1),container=this.el.viewer,parentViewer=this;firstPagePromise.then(function(pdfPage){for(var viewport=pdfPage.getViewport(1*viewerProperties.CSS_UNITS),pageNum=1;pagesCount>=pageNum;++pageNum){var viewportClone=viewport.clone(),pageView=new PageView(container,pageNum,0,viewportClone,parentViewer);bindOnAfterDraw(pageView),pages.push(pageView)}return onePageRendered.then(function(){if(!PDFJS.disableAutoFetch)for(var pageNum=1;pagesCount>=pageNum;++pageNum)pdfDocument.getPage(pageNum).then(function(pageNum,pdfPage){var pageView=pages[pageNum-1];pageView.pdfPage||pageView.setPdfPage(pdfPage);var refStr=pdfPage.ref.num+" "+pdfPage.ref.gen+" R";self.pagesRefMap[refStr]=pageNum,self.linkService.cachePageRef(pageNum,pdfPage.ref)}.bind(null,pageNum))}),downloadedPromise.then(function(){var event=document.createEvent("CustomEvent");event.initCustomEvent("documentload",!0,!0,{}),window.dispatchEvent(event)}),downloadedPromise}),Promise.all([firstPagePromise]).then(function(){self.setInitialView(null,scale)},function(errorMsg){firstPagePromise.then(function(){self.setInitialView(null,scale)})}),self.destinationsPromise=pdfDocument.getDestinations(),self.destinationsPromise.then(function(destinations){self.destinations=destinations}),pdfDocument.getMetadata().then(function(data){var info=data.info,metadata=data.metadata;if(self.documentInfo=info,self.metadata=metadata,PDFJS.pdfBug){var debugMsg=[];debugMsg.push("PDF Fingerprint: "+pdfDocument.fingerprint),debugMsg.push("Version: "+info.PDFFormatVersion),debugMsg.push("Producer: "+(info.Producer||"-").trim()),debugMsg.push("Creator: "+(info.Creator||"-").trim()),debugMsg.push("PDF.js: "+(PDFJS.version||"-")),console.info(debugMsg.join("; "))}var pdfTitle;metadata&&metadata.has("dc:title")&&(pdfTitle=metadata.get("dc:title")),!pdfTitle&&info&&info.Title&&(pdfTitle=info.Title),PDFJS.pdfBug&&pdfTitle&&console.info(pdfTitle),info.IsAcroFormPresent&&(console.warn("Warning: AcroForm/XFA is not supported"),self.fallback(PDFJS.UNSUPPORTED_FEATURES.forms))})},PDFViewer.prototype.setInitialView=function(storedHash,scale){this.currentScale=0,this.currentScaleValue=null;var currentPage=this.pages[0],topLeft=currentPage.getPagePoint(this.el.viewer.scrollLeft-currentPage.x,this.el.viewer.scrollTop-currentPage.y),intLeft=Math.round(topLeft[0]),intTop=Math.round(topLeft[1]);this.currentPosition={page:1,left:intLeft,top:intTop},this.page=1,this.setScale(scale,!0),this.currentScale===viewerProperties.UNKNOWN_SCALE&&this.setScale(viewerProperties.DEFAULT_SCALE,!0)},PDFViewer.prototype.renderHighestPriority=function(){this.idleTimeout&&(clearTimeout(this.idleTimeout),this.idleTimeout=null);var visiblePages=this.getVisiblePages(),pageView=this.getHighestPriority(visiblePages,this.pages,pageViewScroll.down);if(pageView)return void this.renderView(pageView,"page");var that=this;this.idleTimeout=setTimeout(function(){that.cleanup()},viewerProperties.CLEANUP_TIMEOUT)},PDFViewer.prototype.cleanup=function(){for(var i=0,ii=this.pages.length;ii>i;i++)this.pages[i]&&this.pages[i].renderingState!==renderingStates.FINISHED&&this.pages[i].reset();this.pdfDocument.cleanup()},PDFViewer.prototype.getHighestPriority=function(visible,views,scrolledDown){var visibleViews=visible.views,numVisible=visibleViews.length;if(0===numVisible)return!1;for(var i=0;numVisible>i;++i){var view=visibleViews[i].view;if(!this.isViewFinished(view))return view}if(scrolledDown){var nextPageIndex=visible.last.id;if(views[nextPageIndex]&&!this.isViewFinished(views[nextPageIndex]))return views[nextPageIndex]}else{var previousPageIndex=visible.first.id-2;if(views[previousPageIndex]&&!this.isViewFinished(views[previousPageIndex]))return views[previousPageIndex]}return!1},PDFViewer.prototype.isViewFinished=function(view){return view.renderingState===renderingStates.FINISHED},PDFViewer.prototype.renderView=function(view,type){var state=view.renderingState;switch(state){case renderingStates.FINISHED:return!1;case renderingStates.PAUSED:this.highestPriorityPage=type+view.id,view.resume();break;case renderingStates.RUNNING:this.highestPriorityPage=type+view.id;break;case renderingStates.INITIAL:this.highestPriorityPage=type+view.id,view.draw(this.renderHighestPriority.bind(this))}return!0},PDFViewer.prototype.getVisibleElements=function(scrollEl,views,sortByVisibility){for(var view,currentHeight,viewHeight,hiddenHeight,percentHeight,currentWidth,viewWidth,top=scrollEl.scrollTop,bottom=top+scrollEl.clientHeight,left=scrollEl.scrollLeft,right=left+scrollEl.clientWidth,visible=[],i=0,ii=views.length;ii>i;++i)if(view=views[i],currentHeight=view.el.offsetTop+view.el.clientTop,viewHeight=view.el.clientHeight,!(top>currentHeight+viewHeight)){if(currentHeight>bottom)break;currentWidth=view.el.offsetLeft+view.el.clientLeft,viewWidth=view.el.clientWidth,left>currentWidth+viewWidth||currentWidth>right||(hiddenHeight=Math.max(0,top-currentHeight)+Math.max(0,currentHeight+viewHeight-bottom),percentHeight=100*(viewHeight-hiddenHeight)/viewHeight|0,visible.push({id:view.id,x:currentWidth,y:currentHeight,view:view,percent:percentHeight}))}var first=visible[0],last=visible[visible.length-1];return sortByVisibility&&visible.sort(function(a,b){var pc=a.percent-b.percent;return Math.abs(pc)>.001?-pc:a.id-b.id}),{first:first,last:last,views:visible}},PDFViewer.prototype.getVisiblePages=function(){if(PresentationMode.active){var visible=[],currentPage=this.pages[this.page-1];return visible.push({id:currentPage.id,view:currentPage}),{first:currentPage,last:currentPage,views:visible}}return this.getVisibleElements(this.el.container,this.pages,!0)},PDFViewer.prototype.updateViewarea=function(){var visible=this.getVisiblePages();if(visible&&0!==visible.views.length){var visiblePages=visible.views,suggestedCacheSize=Math.max(viewerProperties.DEFAULT_CACHE_SIZE,2*visiblePages.length+1);cache.resize(suggestedCacheSize),this.renderHighestPriority(visible);for(var currentId=this.page,firstPage=visible.first,i=0,ii=visiblePages.length,stillFullyVisible=!1;ii>i;++i){var page=visiblePages[i];if(page.percent<100)break;if(page.id===this.page){stillFullyVisible=!0;break}}stillFullyVisible||(currentId=visiblePages[0].id),PresentationMode.active||(this.updateViewarea.inProgress=!0,this.page=currentId,this.updateViewarea.inProgress=!1);var pageNumber=firstPage.id,currentPage=this.pages[pageNumber-1],container=this.el.container,topLeft=currentPage.getPagePoint(container.scrollLeft-firstPage.x,container.scrollTop-firstPage.y),intLeft=Math.round(topLeft[0]),intTop=Math.round(topLeft[1]);PresentationMode.active||PresentationMode.switchInProgress?this.currentPosition=null:this.currentPosition={page:pageNumber,left:intLeft,top:intTop}}},PDFViewer.prototype.getPage=function(n){return this.pdfDocument.getPage(n)},PDFViewer.prototype.fallback=function(){},PDFViewer.prototype.progress=function(){},PDFViewer.prototype.goToNextPage=function(){this.goToPage(this.page+1)},PDFViewer.prototype.goToPreviousPage=function(){this.goToPage(this.page-1)},PDFViewer.prototype.goToPage=function(pageNumber){this.pages&&this.pages[pageNumber-1]&&this.pages[pageNumber-1].scrollIntoView([null,{name:"Fit"}])},PDFViewer.prototype.scrollPageIntoView=function(pageNumber,dest){if(this.pdfDocument){var pageView=this.pages[pageNumber-1];if(this.isInPresentationMode){if(this._currentPageNumber!==pageView.id)return void(this.currentPageNumber=pageView.id);dest=null,this._setScale(this._currentScaleValue,!0)}if(!dest)return void pageView.scrollIntoView(pageView.div,this.el.viewer);var widthScale,heightScale,x=0,y=0,width=0,height=0,changeOrientation=pageView.rotation%180!==0,pageWidth=(changeOrientation?pageView.height:pageView.width)/pageView.scale/viewerProperties.CSS_UNITS,pageHeight=(changeOrientation?pageView.width:pageView.height)/pageView.scale/viewerProperties.CSS_UNITS,scale=0;switch(dest[1].name){case"XYZ":x=dest[2],y=dest[3],scale=dest[4],x=null!==x?x:0,y=null!==y?y:pageHeight;break;case"Fit":case"FitB":scale="page-fit";break;case"FitH":case"FitBH":y=dest[2],scale="page-width",null===y&&this._location&&(x=this._location.left,y=this._location.top);break;case"FitV":case"FitBV":x=dest[2],width=pageWidth,height=pageHeight,scale="page-height";break;case"FitR":x=dest[2],y=dest[3],width=dest[4]-x,height=dest[5]-y;var hPadding=this.removePageBorders?0:viewerProperties.SCROLLBAR_PADDING,vPadding=this.removePageBorders?0:viewerProperties.VERTICAL_PADDING;widthScale=(this.container.clientWidth-hPadding)/width/viewerProperties.CSS_UNITS,heightScale=(this.container.clientHeight-vPadding)/height/viewerProperties.CSS_UNITS,scale=Math.min(Math.abs(widthScale),Math.abs(heightScale));break;default:return}if(scale&&scale!==this._currentScale?this.currentScaleValue=scale:this._currentScale===viewerProperties.UNKNOWN_SCALE&&(this.currentScaleValue=viewerProperties.DEFAULT_SCALE_VALUE),"page-fit"===scale&&!dest[4])return void pageView.scrollIntoView(pageView.div,this.el.viewer);var boundingRect=[pageView.viewport.convertToViewportPoint(x,y),pageView.viewport.convertToViewportPoint(x+width,y+height)],left=Math.min(boundingRect[0][0],boundingRect[1][0]),top=Math.min(boundingRect[0][1],boundingRect[1][1]);pageView.scrollIntoView(pageView.div,this.el.viewer,{left:left,top:top})}},PDFViewer}),define("pdf-viewer/presentation-mode",[],function(){return{}}),define("pdf-viewer/rendering-states",[],function(){var RenderingStates={INITIAL:0,RUNNING:1,PAUSED:2,FINISHED:3};return RenderingStates}),define("pdf-viewer/text-layer-builder",["pdf-viewer/viewer-properties"],function(viewerProperties){function TextLayerBuilder(options){this.textLayerDiv=options.textLayerDiv,this.layoutDone=!1,this.divContentDone=!1,this.pageIdx=options.pageIndex,this.matches=[],this.lastScrollSource=options.lastScrollSource||null,this.viewport=options.viewport,this.isViewerInPresentationMode=options.isViewerInPresentationMode,this.textDivs=[],this.findController=window.PDFFindController||null}var PDFJS=window.PDFJS,CustomStyle=PDFJS.CustomStyle;return TextLayerBuilder.prototype={renderLayer:function(){var textLayerFrag=document.createDocumentFragment(),textDivs=this.textDivs,textDivsLength=textDivs.length,canvas=document.createElement("canvas"),ctx=canvas.getContext("2d");if(!(textDivsLength>viewerProperties.MAX_TEXT_DIVS_TO_RENDER)){for(var i=0;textDivsLength>i;i++){var textDiv=textDivs[i];if(void 0===textDiv.dataset.isWhitespace){ctx.font=textDiv.style.fontSize+" "+textDiv.style.fontFamily;var width=ctx.measureText(textDiv.textContent).width;if(width>0){textLayerFrag.appendChild(textDiv);var textScale=textDiv.dataset.canvasWidth/width,rotation=textDiv.dataset.angle,transform="scale("+textScale+", 1)";transform="rotate("+rotation+"deg) "+transform,CustomStyle.setProp("transform",textDiv,transform),CustomStyle.setProp("transformOrigin",textDiv,"0% 0%")}}}this.textLayerDiv.appendChild(textLayerFrag),this.renderingDone=!0}},setupRenderLayoutTimer:function(){var self=this,lastScroll=null===this.lastScrollSource?0:this.lastScrollSource.lastScroll;Date.now()-lastScroll>viewerProperties.RENDER_DELAY?this.renderLayer():(this.renderTimer&&clearTimeout(this.renderTimer),this.renderTimer=setTimeout(function(){self.setupRenderLayoutTimer()},viewerProperties.RENDER_DELAY))},appendText:function(geom,styles){var style=styles[geom.fontName],textDiv=document.createElement("div");if(this.textDivs.push(textDiv),!/\S/.test(geom.str))return void(textDiv.dataset.isWhitespace=!0);var tx=PDFJS.Util.transform(this.viewport.transform,geom.transform),angle=Math.atan2(tx[1],tx[0]);style.vertical&&(angle+=Math.PI/2);var fontHeight=Math.sqrt(tx[2]*tx[2]+tx[3]*tx[3]),fontAscent=style.ascent?style.ascent*fontHeight:style.descent?(1+style.descent)*fontHeight:fontHeight;textDiv.style.position="absolute",textDiv.style.left=tx[4]+fontAscent*Math.sin(angle)+"px",textDiv.style.top=tx[5]-fontAscent*Math.cos(angle)+"px",textDiv.style.fontSize=fontHeight+"px",textDiv.style.fontFamily=style.fontFamily,textDiv.textContent=geom.str,textDiv.dataset.fontName=geom.fontName,textDiv.dataset.angle=angle*(180/Math.PI),style.vertical?textDiv.dataset.canvasWidth=geom.height*this.viewport.scale:textDiv.dataset.canvasWidth=geom.width*this.viewport.scale},setTextContent:function(textContent){this.textContent=textContent;for(var textItems=textContent.items,i=0,len=textItems.length;len>i;i++)this.appendText(textItems[i],textContent.styles);this.divContentDone=!0,this.setupRenderLayoutTimer()}},TextLayerBuilder}),define("pdf-viewer/viewer-properties",[],function(){return{DEFAULT_SCALE:"auto",DEFAULT_SCALE_PRESENTATION:"page-fit",DEFAULT_SCALE_DELTA:1.1,DEFAULT_CACHE_SIZE:10,UNKNOWN_SCALE:0,CSS_UNITS:96/72,SCROLLBAR_PADDING:40,VERTICAL_PADDING:20,NAVIGATION_ARROW_PADDING:160,MAX_AUTO_SCALE:1.25,MIN_SCALE:.25,MAX_SCALE:4,USE_ONLY_CSS_ZOOM:!1,CLEANUP_TIMEOUT:3e4,IGNORE_CURRENT_POSITION_ON_ZOOM:!1,RENDER_DELAY:200,MAX_TEXT_DIVS_TO_RENDER:1e5}})}(function(){var FileViewer;return FileViewer="undefined"!=typeof module&&"exports"in module?require("./fileviewer.js"):window.require?window.FileViewer:window.FileViewer}());